<?php
session_start();
if (empty($_SESSION['logueado'])) {
    header("Location: login.php");
    exit;
}

require 'db.php';

$accion = $_GET['accion'] ?? $_POST['accion'] ?? '';
$id = $_GET['id'] ?? $_POST['id'] ?? null;

if ($accion === 'agregar' && !empty($_POST['dominio'])) {
    // Agregar dominio autorizado
    $nombre = trim($_POST['nombre'] ?? '');
    $dominio = trim($_POST['dominio']);
    
    // Limpiar el dominio (quitar http, https, www, etc)
    $dominio = preg_replace('#^https?://(www\.)?#', '', $dominio);
    $dominio = rtrim($dominio, '/');
    
    $stmt = $pdo->prepare("INSERT INTO dominios (nombre, dominio, estado) VALUES (?, ?, 'activo')");
    $stmt->execute([$nombre, $dominio]);
    header("Location: index.php?seccion=dominios");
    exit;
}

if ($accion === 'editar' && $id && !empty($_POST['dominio'])) {
    // Editar dominio
    $nombre = trim($_POST['nombre'] ?? '');
    $dominio = trim($_POST['dominio']);
    
    // Limpiar el dominio (quitar http, https, www, etc)
    $dominio = preg_replace('#^https?://(www\.)?#', '', $dominio);
    $dominio = rtrim($dominio, '/');
    
    $stmt = $pdo->prepare("UPDATE dominios SET nombre=?, dominio=? WHERE id=?");
    $stmt->execute([$nombre, $dominio, $id]);
    header("Location: index.php?seccion=dominios");
    exit;
}

if ($accion === 'bloquear' && $id) {
    // Cambiar estado a inactivo (bloqueado)
    $stmt = $pdo->prepare("UPDATE dominios SET estado='inactivo' WHERE id=?");
    $stmt->execute([$id]);
    header("Location: index.php?seccion=dominios");
    exit;
}

if ($accion === 'activar' && $id) {
    // Cambiar estado a activo
    $stmt = $pdo->prepare("UPDATE dominios SET estado='activo' WHERE id=?");
    $stmt->execute([$id]);
    header("Location: index.php?seccion=dominios");
    exit;
}

if ($accion === 'eliminar' && $id) {
    // Eliminar dominio
    $stmt = $pdo->prepare("DELETE FROM dominios WHERE id=?");
    $stmt->execute([$id]);
    header("Location: index.php?seccion=dominios");
    exit;
}

// Si llega aquí, acción inválida
header("Location: index.php?seccion=dominios");
exit;