<?php
session_start();

if (empty($_SESSION['logueado'])) {
    header("Location: login.php");
    exit;
}

require 'db.php';

$accion = $_POST['accion'] ?? $_GET['accion'] ?? '';
$usuario_id = $_SESSION['usuario_id'] ?? 1; // Cambiar según tu sistema de login

header('Content-Type: application/json');

try {
    switch($accion) {
        // CREAR NOTA
        case 'crear':
            $titulo = $_POST['titulo'] ?? '';
            $contenido = $_POST['contenido'] ?? '';
            $categoria = $_POST['categoria'] ?? 'General';
            $color = $_POST['color'] ?? '#8b5cf6';
            
            if (empty($titulo) || empty($contenido)) {
                echo json_encode(['success' => false, 'error' => 'Título y contenido requeridos']);
                exit;
            }
            
            $stmt = $pdo->prepare("
                INSERT INTO notas (usuario_id, titulo, contenido, categoria, color)
                VALUES (?, ?, ?, ?, ?)
            ");
            
            $stmt->execute([$usuario_id, $titulo, $contenido, $categoria, $color]);
            
            echo json_encode([
                'success' => true,
                'message' => 'Nota creada exitosamente',
                'id' => $pdo->lastInsertId()
            ]);
            break;
            
        // ACTUALIZAR NOTA
        case 'actualizar':
            $id = $_POST['id'] ?? 0;
            $titulo = $_POST['titulo'] ?? '';
            $contenido = $_POST['contenido'] ?? '';
            $categoria = $_POST['categoria'] ?? 'General';
            $color = $_POST['color'] ?? '#8b5cf6';
            
            if (empty($id) || empty($titulo)) {
                echo json_encode(['success' => false, 'error' => 'ID y título requeridos']);
                exit;
            }
            
            $stmt = $pdo->prepare("
                UPDATE notas 
                SET titulo = ?, contenido = ?, categoria = ?, color = ?
                WHERE id = ? AND usuario_id = ?
            ");
            
            $stmt->execute([$titulo, $contenido, $categoria, $color, $id, $usuario_id]);
            
            echo json_encode(['success' => true, 'message' => 'Nota actualizada']);
            break;
            
        // ELIMINAR NOTA
        case 'eliminar':
            $id = $_GET['id'] ?? 0;
            
            $stmt = $pdo->prepare("DELETE FROM notas WHERE id = ? AND usuario_id = ?");
            $stmt->execute([$id, $usuario_id]);
            
            $_SESSION['exito'] = 'Nota eliminada';
            header("Location: index.php?seccion=notas");
            exit;
            
        // ARCHIVAR NOTA
        case 'archivar':
            $id = $_POST['id'] ?? 0;
            $archivada = $_POST['archivada'] ?? false;
            
            $stmt = $pdo->prepare("
                UPDATE notas SET archivada = ? WHERE id = ? AND usuario_id = ?
            ");
            
            $stmt->execute([$archivada, $id, $usuario_id]);
            
            echo json_encode(['success' => true]);
            break;
            
        // OBTENER NOTAS
        case 'obtener':
            $categoria = $_GET['categoria'] ?? 'todas';
            $busqueda = $_GET['busqueda'] ?? '';
            $mostrar_archivadas = $_GET['archivadas'] ?? 'no';
            
            $query = "SELECT * FROM notas WHERE usuario_id = ?";
            $params = [$usuario_id];
            
            if ($mostrar_archivadas === 'no') {
                $query .= " AND archivada = 0";
            }
            
            if ($categoria !== 'todas') {
                $query .= " AND categoria = ?";
                $params[] = $categoria;
            }
            
            if (!empty($busqueda)) {
                $query .= " AND (titulo LIKE ? OR contenido LIKE ?)";
                $search_term = "%$busqueda%";
                $params[] = $search_term;
                $params[] = $search_term;
            }
            
            $query .= " ORDER BY actualizada_en DESC";
            
            $stmt = $pdo->prepare($query);
            $stmt->execute($params);
            $notas = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo json_encode(['success' => true, 'notas' => $notas]);
            break;
            
        // OBTENER CATEGORÍAS
        case 'categorias':
            $stmt = $pdo->prepare("
                SELECT * FROM categorias_notas WHERE usuario_id = ? ORDER BY nombre
            ");
            $stmt->execute([$usuario_id]);
            $categorias = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo json_encode(['success' => true, 'categorias' => $categorias]);
            break;
            
        // CREAR CATEGORÍA
        case 'crear_categoria':
            $nombre = $_POST['nombre'] ?? '';
            $color = $_POST['color'] ?? '#8b5cf6';
            
            if (empty($nombre)) {
                echo json_encode(['success' => false, 'error' => 'Nombre requerido']);
                exit;
            }
            
            $stmt = $pdo->prepare("
                INSERT INTO categorias_notas (usuario_id, nombre, color)
                VALUES (?, ?, ?)
            ");
            
            $stmt->execute([$usuario_id, $nombre, $color]);
            
            echo json_encode([
                'success' => true,
                'message' => 'Categoría creada',
                'id' => $pdo->lastInsertId()
            ]);
            break;
            
        default:
            echo json_encode(['success' => false, 'error' => 'Acción no reconocida']);
    }
} catch(Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}