<?php
session_start();

if (empty($_SESSION['logueado'])) {
    header("Location: login.php");
    exit;
}

require 'db.php';

$accion = $_GET['accion'] ?? $_POST['accion'] ?? '';
$id = $_GET['id'] ?? $_POST['id'] ?? null;

// Generar PIN aleatorio (6 dígitos)
function generarPIN() {
    return str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
}

// EDITAR INFORMACIÓN
if ($accion === 'editar_info') {
    $nombre = $_POST['nombre'] ?? '';
    $dominio = $_POST['dominio'] ?? '';
    $descripcion = $_POST['descripcion'] ?? '';
    
    if (!$id || empty($nombre) || empty($dominio)) {
        header("Location: index.php?seccion=plantillas&error=Datos incompletos");
        exit;
    }
    
    try {
        $stmt = $pdo->prepare("UPDATE plantillas SET nombre=?, dominio=?, descripcion=? WHERE id=?");
        $stmt->execute([$nombre, $dominio, $descripcion, $id]);
        
        header("Location: index.php?seccion=plantillas");
        exit;
    } catch (Exception $e) {
        header("Location: index.php?seccion=plantillas&error=" . urlencode($e->getMessage()));
        exit;
    }
}

if ($accion === 'agregar') {
    $nombre = $_POST['nombre'] ?? '';
    $dominio = $_POST['dominio'] ?? '';
    $descripcion = $_POST['descripcion'] ?? '';
    $pin = generarPIN();
    
    if (empty($nombre) || empty($dominio)) {
        header("Location: index.php?seccion=plantillas&error=Datos incompletos");
        exit;
    }
    
    try {
        $stmt = $pdo->prepare("
            INSERT INTO plantillas (nombre, descripcion, dominio, pin, activa) 
            VALUES (?, ?, ?, ?, 1)
        ");
        $stmt->execute([$nombre, $descripcion, $dominio, $pin]);
        
        $plantilla_id = $pdo->lastInsertId();
        
        // Crear archivos vacíos
        foreach (['html', 'css', 'js'] as $tipo) {
            $stmt = $pdo->prepare("
                INSERT INTO plantilla_archivos (plantilla_id, tipo, contenido) 
                VALUES (?, ?, '')
            ");
            $stmt->execute([$plantilla_id, $tipo]);
        }
        
        header("Location: editor_plantilla.php?id=$plantilla_id&nuevo=1");
        exit;
    } catch (Exception $e) {
        header("Location: index.php?seccion=plantillas&error=" . urlencode($e->getMessage()));
        exit;
    }
}

if ($accion === 'activar') {
    if (!$id) exit;
    
    try {
        $stmt = $pdo->prepare("UPDATE plantillas SET activa=1 WHERE id=?");
        $stmt->execute([$id]);
        
        header("Location: index.php?seccion=plantillas");
        exit;
    } catch (Exception $e) {
        die($e->getMessage());
    }
}

if ($accion === 'desactivar') {
    if (!$id) exit;
    
    try {
        $stmt = $pdo->prepare("UPDATE plantillas SET activa=0 WHERE id=?");
        $stmt->execute([$id]);
        
        header("Location: index.php?seccion=plantillas");
        exit;
    } catch (Exception $e) {
        die($e->getMessage());
    }
}

if ($accion === 'eliminar') {
    if (!$id) exit;
    
    try {
        $stmt = $pdo->prepare("DELETE FROM plantillas WHERE id=?");
        $stmt->execute([$id]);
        
        header("Location: index.php?seccion=plantillas");
        exit;
    } catch (Exception $e) {
        die($e->getMessage());
    }
}

header("Location: index.php?seccion=plantillas");
exit;
?>