<?php
session_start();
if (empty($_SESSION['logueado'])) {
    header("Location: login.php");
    exit;
}

require 'db.php';

$accion = $_GET['accion'] ?? $_POST['accion'] ?? '';
$id = $_GET['id'] ?? $_POST['id'] ?? null;

if ($accion === 'agregar' && !empty($_POST['url']) && !empty($_POST['tipo'])) {
    // Agregar streaming con nombre
    $nombre = trim($_POST['nombre'] ?? '');
    $url = trim($_POST['url']);
    $tipo = $_POST['tipo'];
    
    $stmt = $pdo->prepare("INSERT INTO streamings (nombre, url, tipo, estado) VALUES (?, ?, ?, 'activo')");
    $stmt->execute([$nombre, $url, $tipo]);
    header("Location: index.php?seccion=streamings");
    exit;
}

if ($accion === 'editar' && $id && !empty($_POST['url']) && !empty($_POST['tipo'])) {
    // Editar streaming
    $nombre = trim($_POST['nombre'] ?? '');
    $url = trim($_POST['url']);
    $tipo = $_POST['tipo'];
    
    $stmt = $pdo->prepare("UPDATE streamings SET nombre=?, url=?, tipo=? WHERE id=?");
    $stmt->execute([$nombre, $url, $tipo, $id]);
    header("Location: index.php?seccion=streamings");
    exit;
}

if ($accion === 'suspender' && $id) {
    // Cambiar estado a inactivo
    $stmt = $pdo->prepare("UPDATE streamings SET estado='inactivo' WHERE id=?");
    $stmt->execute([$id]);
    header("Location: index.php?seccion=streamings");
    exit;
}

if ($accion === 'activar' && $id) {
    // Cambiar estado a activo
    $stmt = $pdo->prepare("UPDATE streamings SET estado='activo' WHERE id=?");
    $stmt->execute([$id]);
    header("Location: index.php?seccion=streamings");
    exit;
}

if ($accion === 'eliminar' && $id) {
    // Eliminar streaming
    $stmt = $pdo->prepare("DELETE FROM streamings WHERE id=?");
    $stmt->execute([$id]);
    header("Location: index.php?seccion=streamings");
    exit;
}

// Si llega aquí, acción inválida
header("Location: index.php?seccion=streamings");
exit;