<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$accion = $_GET['accion'] ?? '';
$slug = $_GET['slug'] ?? '';
$id_radio = $_GET['id_radio'] ?? '';
$dia = $_GET['dia'] ?? 'lunes';

// 73 FUNCI07N PARA LLAMAR A PLAYZONASTORE CON VERIFICACI07N
function llamarPlayZona($url) {
    try {
        // Verificar que allow_url_fopen est habilitado
        if (!ini_get('allow_url_fopen')) {
            return json_encode(['error' => 'allow_url_fopen deshabilitado']);
        }
        
        // Crear contexto para evitar errores de SSL
        $context = stream_context_create([
            'http' => [
                'timeout' => 10,
                'ignore_errors' => true
            ],
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false
            ]
        ]);
        
        $response = @file_get_contents($url, false, $context);
        
        if ($response === false) {
            return json_encode(['error' => 'No se pudo conectar a PlayZonaStore']);
        }
        
        return $response;
        
    } catch (Exception $e) {
        return json_encode(['error' => $e->getMessage()]);
    }
}

// 73 OBTENER RADIO
if ($accion === 'obtener_radio') {
    $url = 'https://playzonastore.com/app/api_funciones.php?accion=obtener_radio&slug=' . urlencode($slug);
    echo llamarPlayZona($url);
    exit;
}

// 73 OBTENER PROGRAMACI07N
if ($accion === 'obtener_programacion') {
    $url = 'https://playzonastore.com/app/api_funciones.php?accion=obtener_programacion&id_radio=' . urlencode($id_radio) . '&dia=' . urlencode($dia);
    echo llamarPlayZona($url);
    exit;
}

// 73 OBTENER VIDEOS
if ($accion === 'obtener_videos') {
    $url = 'https://playzonastore.com/app/api_funciones.php?accion=obtener_videos&id_radio=' . urlencode($id_radio);
    echo llamarPlayZona($url);
    exit;
}

// 73 OBTENER NOTICIAS
if ($accion === 'obtener_noticias') {
    $url = 'https://playzonastore.com/app/api_funciones.php?accion=obtener_noticias&id_radio=' . urlencode($id_radio);
    echo llamarPlayZona($url);
    exit;
}

// 73 OBTENER PODCASTS
if ($accion === 'obtener_podcasts') {
    $url = 'https://playzonastore.com/app/api_funciones.php?accion=obtener_podcasts&id_radio=' . urlencode($id_radio);
    echo llamarPlayZona($url);
    exit;
}

// 73 OBTENER SLIDER
if ($accion === 'obtener_slider') {
    $url = 'https://playzonastore.com/app/api_funciones.php?accion=obtener_slider&id_radio=' . urlencode($id_radio);
    echo llamarPlayZona($url);
    exit;
}

// 73 OBTENER HISTORIAL
if ($accion === 'obtener_historial') {
    $url = 'https://playzonastore.com/app/api_funciones.php?accion=obtener_historial&id_radio=' . urlencode($id_radio);
    echo llamarPlayZona($url);
    exit;
}

echo json_encode(['error' => 'Accin no vlida']);
?>