<?php
require '../../db.php';

header('Content-Type: text/plain; charset=utf-8');
header("Access-Control-Allow-Origin: *");

$accion = $_GET['accion'] ?? '';
$plantilla_id = $_GET['id'] ?? null;
$tipo = $_GET['tipo'] ?? 'html';

// OBTENER PLANTILLA
if ($accion === 'obtener') {
    try {
        $stmt = $pdo->prepare("SELECT * FROM plantillas WHERE id=? AND activa=1");
        $stmt->execute([$plantilla_id]);
        $plantilla = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$plantilla) {
            http_response_code(404);
            echo "<!-- Plantilla no encontrada -->";
            exit;
        }
        
        // OBTENER CONTENIDO
        $stmt = $pdo->prepare("SELECT contenido FROM plantilla_archivos WHERE plantilla_id=? AND tipo=?");
        $stmt->execute([$plantilla_id, $tipo]);
        $archivo = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$archivo || empty($archivo['contenido'])) {
            if ($tipo === 'html') {
                echo "<h1>Plantilla " . $plantilla_id . " cargada</h1>";
            } elseif ($tipo === 'css') {
                echo "/* CSS Plantilla " . $plantilla_id . " */";
            } else {
                echo "console.log('JS Plantilla " . $plantilla_id . "');";
            }
            exit;
        }
        
        // SERVIR CONTENIDO
        if ($tipo === 'js') {
            header('Content-Type: application/javascript; charset=utf-8');
        } elseif ($tipo === 'css') {
            header('Content-Type: text/css; charset=utf-8');
        } else {
            header('Content-Type: text/html; charset=utf-8');
        }
        
        echo $archivo['contenido'];
        exit;
        
    } catch (Exception $e) {
        echo "<!-- Error: " . $e->getMessage() . " -->";
        exit;
    }
}

echo "<!-- Error: No action -->";
?>