<?php
header('Content-Type: application/json');

// Verificar si se proporciona una URL
if (!isset($_REQUEST['url'])) {
    echo json_encode(["error" => "No se proporcionó una URL"]);
    exit();
}

$url = urldecode($_REQUEST['url']);

$ch = curl_init();
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 15);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

$return_json = curl_exec($ch);

if (curl_errno($ch)) {
    echo json_encode(["error" => 'Error de cURL: ' . curl_error($ch)]);
    exit();
}

curl_close($ch);

// **PRIMER PASO: IMPRIMIR LA RESPUESTA DEL SERVIDOR**
file_put_contents("debug_response.json", $return_json); // Guarda la respuesta en un archivo para analizarla

// Decodificar JSON
$obj = json_decode($return_json, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(["error" => "Error al decodificar JSON"]);
    exit();
}

// **SEGUNDO PASO: IMPRIMIR EL OBJETO DECODIFICADO**
file_put_contents("debug_parsed.json", json_encode($obj, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

// Extraer el título de la canción
$title = '';

if (isset($obj['icestats']['source'][0]['title'])) {
    $title = $obj['icestats']['source'][0]['title'];
} elseif (isset($obj['title'])) {
    $title = $obj['title'];
} elseif (isset($obj['songtitle'])) {
    $title = $obj['songtitle'];
} elseif (isset($obj['data'][0]['song'])) {
    $title = $obj['data'][0]['song'];
}

// **TERCER PASO: IMPRIMIR EL TÍTULO CRUDO**
file_put_contents("debug_title.txt", $title);

// Eliminar caracteres invisibles, corchetes y paréntesis con contenido
$title = trim(preg_replace('/\s*\[.*?\]|\s*\(.*?\)/', '', $title));

// Intentar separar artista y canción
$artist = "";
$song = "Sin título";

// Verificar si hay un separador válido
if (strpos($title, ' - ') !== false) {
    list($artist, $song) = explode(' - ', $title, 2);
} elseif (strpos($title, ' – ') !== false) { // Separador " – " (guion largo)
    list($artist, $song) = explode(' – ', $title, 2);
} elseif (strpos($title, ': ') !== false) { // Algunos servidores usan "Artista: Canción"
    list($artist, $song) = explode(': ', $title, 2);
} else {
    // Si no hay separador claro, asumir que todo es la canción y el artista es "Desconocido"
    $song = $title;
}

// **CUARTO PASO: IMPRIMIR ARTISTA Y CANCIÓN EXTRAÍDOS**
file_put_contents("debug_artist_song.json", json_encode(["artist" => $artist, "song" => $song], JSON_PRETTY_PRINT));

// Historial de canciones (puedes guardarlo en una base de datos o archivo si lo prefieres)
$song_history = [];

// Asegurarse de que el archivo existe y se puede leer
if (file_exists('song_history.json')) {
    // Intentamos leer el archivo de historial
    $song_history = json_decode(file_get_contents('song_history.json'), true);

    // Verificar si hubo un error al leer el archivo
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(["error" => "Error al leer el historial de canciones"]);
        exit();
    }
} else {
    // Si el archivo no existe, lo inicializamos como un array vacío
    $song_history = [];
}

// Verificar si la canción ya está en el historial
$isSongInHistory = false;
foreach ($song_history as $historyItem) {
    if (trim($historyItem['song']['title']) == trim($song) && trim($historyItem['song']['artist']) == trim($artist)) {
        $isSongInHistory = true;
        break;
    }
}

// Si la canción no está en el historial, agregarla al principio (para que esté arriba)
if (!$isSongInHistory) {
    array_unshift($song_history, [ // Esto agrega la canción al principio
        "song" => [
            "title" => trim($song),
            "artist" => trim($artist)
        ]
    ]);
}

// Limitar el historial a las 10 canciones más recientes
if (count($song_history) > 10) {
    // Elimina las canciones más antiguas si hay más de 10
    $song_history = array_slice($song_history, 0, 10); // Ahora aseguramos que solo queden las 10 primeras
}

// Guardar el historial de canciones en el archivo
if (file_put_contents('song_history.json', json_encode($song_history, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) === false) {
    echo json_encode(["error" => "Error al guardar el historial de canciones"]);
    exit();
}

// Depuración: verificar que el historial se ha actualizado correctamente
file_put_contents("debug_song_history.json", json_encode($song_history, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

// **Devolver la respuesta en JSON con el bloque solicitado arriba del historial**

echo json_encode([
    "songtitle" => trim($song) . ' - ' . trim($artist),
    "artist" => trim($artist),
    "song" => trim($song),
    "source" => $url,
    "song_history" => $song_history // No invertir el historial
], JSON_UNESCAPED_UNICODE);
?>
