<?php
// ============ api/cargar.php - CARGA TODO EL CONTENIDO ============
// Coloca en: /api/cargar.php

session_start();
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: *');
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require dirname(__DIR__) . '/db.php';

$id = $_GET['id'] ?? null;
$tipo = $_GET['tipo'] ?? null;

if (!$id || !$tipo) {
    http_response_code(400);
    echo json_encode(['error' => 'id y tipo requeridos', 'recibido' => ['id' => $id, 'tipo' => $tipo]]);
    exit;
}

if (!in_array($tipo, ['css', 'js', 'html'])) {
    http_response_code(400);
    echo json_encode(['error' => 'tipo inválido (usa: css, js, html)']);
    exit;
}

try {
    // Verificar que la plantilla existe y está activa
    $stmt = $pdo->prepare("SELECT id, nombre FROM plantillas WHERE id = ? AND activa = 1");
    $stmt->execute([$id]);
    $plantilla = $stmt->fetch();
    
    if (!$plantilla) {
        http_response_code(404);
        echo json_encode(['error' => 'Plantilla no encontrada o no activa', 'id_buscado' => $id]);
        exit;
    }
    
    // Obtener TODOS los contenidos de ese tipo (puede haber múltiples registros)
    $stmt = $pdo->prepare("SELECT contenido FROM plantilla_archivos WHERE plantilla_id = ? AND tipo = ? ORDER BY id ASC");
    $stmt->execute([$id, $tipo]);
    $archivos = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    // Juntar todos los contenidos
    $contenido = implode("\n", $archivos);
    
    if (empty($contenido)) {
        $contenido = "/* Contenido vacío para plantilla " . $plantilla['nombre'] . " tipo " . $tipo . " */";
    }
    
    $contenido_original_len = strlen($contenido);
    
    // NO minificar - devolver contenido completo
    echo json_encode([
        'success' => true,
        'contenido' => $contenido,
        'tipo' => $tipo,
        'plantilla' => $plantilla['nombre'],
        'plantilla_id' => $id,
        'tamaño' => $contenido_original_len,
        'archivos_encontrados' => count($archivos)
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage(), 'archivo' => $e->getFile(), 'linea' => $e->getLine()]);
}
?>