<?php
// api/eliminar_imagen.php
session_start();
require '../db.php';

$plantilla_id = $_POST['plantilla_id'] ?? null;
$url = $_POST['url'] ?? null;

if (!$plantilla_id || !$url) {
    header('Content-Type: application/json');
    echo json_encode(['ok' => false, 'error' => 'Datos inválidos']);
    exit;
}

// Decodificar la ruta
$ruta = base64_decode($url);

// Validar que la ruta es válida (evitar path traversal)
if (strpos($ruta, '..') !== false || !file_exists($ruta)) {
    header('Content-Type: application/json');
    echo json_encode(['ok' => false, 'error' => 'Archivo no encontrado']);
    exit;
}

// Eliminar archivo
if (unlink($ruta)) {
    header('Content-Type: application/json');
    echo json_encode(['ok' => true]);
} else {
    header('Content-Type: application/json');
    echo json_encode(['ok' => false, 'error' => 'No se pudo eliminar']);
}
?>