<?php
session_start();
require '../db.php';

header('Content-Type: application/json; charset=utf-8');

if (empty($_SESSION['logueado'])) {
    die(json_encode(['error' => 'No autenticado']));
}

$plantilla_id = $_GET['plantilla_id'] ?? null;
$tipo = $_GET['tipo'] ?? null;
$contenido = $_POST['contenido'] ?? '';

if (!$plantilla_id || !$tipo) {
    die(json_encode(['error' => 'Parámetros faltantes']));
}

try {
    $stmt = $pdo->prepare("
        UPDATE plantilla_archivos 
        SET contenido=?, fecha_modificacion=NOW() 
        WHERE plantilla_id=? AND tipo=?
    ");
    $stmt->execute([$contenido, $plantilla_id, $tipo]);
    
    die(json_encode(['ok' => true, 'msg' => 'Guardado correctamente']));
} catch (Exception $e) {
    die(json_encode(['error' => $e->getMessage()]));
}
?>