<?php
/**
 * Script para insertar/actualizar CSS en la BD
 * Ubicación: proapi.zonaradio.net/admin/insertar-css.php
 */

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['error' => 'Solo POST permitido']);
    exit;
}

// Verificar que sea admin (ajusta según tu sistema)
// session_start();
// if (!isset($_SESSION['admin']) || !$_SESSION['admin']) {
//     echo json_encode(['error' => 'No autorizado']);
//     exit;
// }

$nombre = isset($_POST['nombre']) ? trim($_POST['nombre']) : '';
$contenido = isset($_POST['contenido']) ? $_POST['contenido'] : '';

// Validar
if (empty($nombre) || empty($contenido)) {
    echo json_encode(['error' => 'Nombre y contenido requeridos']);
    exit;
}

// Validar nombre
$nombre = preg_replace('/[^a-zA-Z0-9_-]/', '', $nombre);

if (empty($nombre)) {
    echo json_encode(['error' => 'Nombre inválido']);
    exit;
}

try {
    // Conectar a BD
    $db_host = 'localhost';
    $db_user = 'root'; // Cambia
    $db_pass = ''; // Cambia
    $db_name = 'zonaradio'; // Cambia
    
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
    
    if ($conn->connect_error) {
        echo json_encode(['error' => 'Error BD: ' . $conn->connect_error]);
        exit;
    }
    
    $conn->set_charset("utf8mb4");
    
    // Crear tabla si no existe
    $create_sql = "CREATE TABLE IF NOT EXISTS css_archivos (
        id INT PRIMARY KEY AUTO_INCREMENT,
        nombre VARCHAR(100) UNIQUE NOT NULL,
        contenido LONGTEXT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_nombre (nombre)
    ) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";
    
    $conn->query($create_sql);
    
    // INSERT OR UPDATE
    $sql = "INSERT INTO css_archivos (nombre, contenido) 
            VALUES (?, ?)
            ON DUPLICATE KEY UPDATE 
            contenido = VALUES(contenido),
            updated_at = CURRENT_TIMESTAMP";
    
    $stmt = $conn->prepare($sql);
    
    if (!$stmt) {
        echo json_encode(['error' => 'Error prepare: ' . $conn->error]);
        exit;
    }
    
    $stmt->bind_param("ss", $nombre, $contenido);
    
    if (!$stmt->execute()) {
        echo json_encode(['error' => 'Error execute: ' . $stmt->error]);
        exit;
    }
    
    $stmt->close();
    $conn->close();
    
    echo json_encode([
        'success' => true,
        'mensaje' => "CSS '$nombre' guardado correctamente",
        'url' => "https://proapi.zonaradio.net/api/obtener-css.php?nombre=$nombre"
    ]);
    
} catch (Exception $e) {
    echo json_encode(['error' => 'Exception: ' . $e->getMessage()]);
    exit;
}
?>