<?php
/**
 * API para obtener CSS desde la base de datos
 * Ubicación: proapi.zonaradio.net/api/obtener-css.php
 */

// Headers CORS
header('Content-Type: text/css; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Cache-Control: public, max-age=3600'); // Cache 1 hora
header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 3600) . ' GMT');

// Manejar preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Obtener parámetro (nombre del archivo CSS)
$nombre = isset($_GET['nombre']) ? $_GET['nombre'] : 'validador';

// Validar nombre para evitar inyección
$nombre = preg_replace('/[^a-zA-Z0-9_-]/', '', $nombre);

if (empty($nombre)) {
    header('HTTP/1.1 400 Bad Request');
    echo "/* Nombre de CSS inválido */";
    exit;
}

// Conectar a BD
try {
    // Ajusta estos valores con tus credenciales
    $db_host = 'localhost';
    $db_user = 'root'; // Cambia con tu usuario
    $db_pass = ''; // Cambia con tu contraseña
    $db_name = 'zonaradio'; // Cambia con tu BD
    
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
    
    // Verificar conexión
    if ($conn->connect_error) {
        header('HTTP/1.1 500 Internal Server Error');
        error_log('DB Error: ' . $conn->connect_error);
        echo "/* Error de conexión a BD */";
        exit;
    }
    
    // Configurar UTF-8
    $conn->set_charset("utf8mb4");
    
    // Verificar si la tabla existe
    $check_table = $conn->query("SHOW TABLES LIKE 'css_archivos'");
    
    if ($check_table->num_rows === 0) {
        // Crear tabla si no existe
        $create_sql = "CREATE TABLE IF NOT EXISTS css_archivos (
            id INT PRIMARY KEY AUTO_INCREMENT,
            nombre VARCHAR(100) UNIQUE NOT NULL,
            contenido LONGTEXT NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            INDEX idx_nombre (nombre)
        ) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";
        
        if (!$conn->query($create_sql)) {
            error_log('Error creando tabla: ' . $conn->error);
        }
    }
    
    // Obtener CSS de la BD
    $sql = "SELECT contenido FROM css_archivos WHERE nombre = ? LIMIT 1";
    $stmt = $conn->prepare($sql);
    
    if (!$stmt) {
        header('HTTP/1.1 500 Internal Server Error');
        error_log('Error prepare: ' . $conn->error);
        echo "/* Error en preparación de consulta */";
        exit;
    }
    
    $stmt->bind_param("s", $nombre);
    
    if (!$stmt->execute()) {
        header('HTTP/1.1 500 Internal Server Error');
        error_log('Error execute: ' . $stmt->error);
        echo "/* Error ejecutando consulta */";
        exit;
    }
    
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo $row['contenido'];
    } else {
        // CSS por defecto si no existe
        header('HTTP/1.1 404 Not Found');
        echo "/* CSS '{$nombre}' no encontrado en la BD */";
    }
    
    $stmt->close();
    $conn->close();
    
} catch (Exception $e) {
    header('HTTP/1.1 500 Internal Server Error');
    error_log('Exception: ' . $e->getMessage());
    echo "/* Error: " . $e->getMessage() . " */";
    exit;
}
?>