<?php
// api/obtener_tabs.php
session_start();
require '../db.php';

$plantilla_id = $_GET['plantilla_id'] ?? null;

if (!$plantilla_id) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'ID de plantilla no especificado']);
    exit;
}

$tipos = ['html', 'css', 'js'];
$tabs = [];

foreach ($tipos as $tipo) {
    $stmt = $pdo->prepare("SELECT contenido FROM plantilla_archivos WHERE plantilla_id=? AND tipo=?");
    $stmt->execute([$plantilla_id, $tipo]);
    $archivo = $stmt->fetch(PDO::FETCH_ASSOC);
    $tabs[$tipo] = $archivo['contenido'] ?? '';
}

header('Content-Type: application/json');
echo json_encode($tabs);
?>