<?php
// api/renombrar_imagen.php
session_start();
require '../db.php';

$plantilla_id = $_POST['plantilla_id'] ?? null;
$url = $_POST['url'] ?? null;
$nombre_nuevo = $_POST['nombre'] ?? null;

if (!$plantilla_id || !$url || !$nombre_nuevo) {
    header('Content-Type: application/json');
    echo json_encode(['ok' => false, 'error' => 'Datos inválidos']);
    exit;
}

$ruta_actual = base64_decode($url);

// Validar ruta
if (strpos($ruta_actual, '..') !== false || !file_exists($ruta_actual)) {
    header('Content-Type: application/json');
    echo json_encode(['ok' => false, 'error' => 'Archivo no encontrado']);
    exit;
}

// Sanitizar nombre
$nombre_nuevo = preg_replace('/[^a-z0-9._-]/i', '', $nombre_nuevo);

// Si no tiene extensión, agregar la del archivo original
$ext = pathinfo($ruta_actual, PATHINFO_EXTENSION);
if (!preg_match('/\.' . $ext . '$/i', $nombre_nuevo)) {
    $nombre_nuevo = $nombre_nuevo . '.' . $ext;
}

// Generar ruta nueva
$carpeta = dirname($ruta_actual);
$ruta_nueva = $carpeta . '/' . $nombre_nuevo;

// Verificar que no exista
if (file_exists($ruta_nueva) && $ruta_nueva !== $ruta_actual) {
    header('Content-Type: application/json');
    echo json_encode(['ok' => false, 'error' => 'El archivo ya existe']);
    exit;
}

// Renombrar
if (rename($ruta_actual, $ruta_nueva)) {
    header('Content-Type: application/json');
    echo json_encode([
        'ok' => true,
        'nueva_ruta' => $ruta_nueva
    ]);
} else {
    header('Content-Type: application/json');
    echo json_encode(['ok' => false, 'error' => 'No se pudo renombrar']);
}
?>