<?php
// api/subir_imagenes.php
session_start();
require '../db.php';

$plantilla_id = $_POST['plantilla_id'] ?? null;

if (!$plantilla_id || empty($_FILES['images'])) {
    header('Content-Type: application/json');
    echo json_encode(['ok' => false, 'error' => 'Datos inválidos']);
    exit;
}

// Crear directorio si no existe
$imagenFolder = '../plantillas/' . $plantilla_id . '/imagenes';
if (!is_dir($imagenFolder)) {
    if (!mkdir($imagenFolder, 0755, true)) {
        header('Content-Type: application/json');
        echo json_encode(['ok' => false, 'error' => 'No se pudo crear la carpeta']);
        exit;
    }
}

$uploadedImages = [];
$allowedExt = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg'];

foreach ($_FILES['images']['tmp_name'] as $key => $tmp_name) {
    $filename = $_FILES['images']['name'][$key];
    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
    
    if (!in_array($ext, $allowedExt)) {
        continue;
    }
    
    // Generar nombre único
    $newName = uniqid() . '_' . preg_replace('/[^a-z0-9._-]/i', '', $filename);
    $targetPath = $imagenFolder . '/' . $newName;
    
    if (move_uploaded_file($tmp_name, $targetPath)) {
        $uploadedImages[] = [
            'nombre' => $newName,
            'ruta' => $imagenFolder . '/' . $newName,
            'url' => base64_encode($imagenFolder . '/' . $newName)
        ];
    }
}

header('Content-Type: application/json');
echo json_encode([
    'ok' => true,
    'imagenes' => $uploadedImages
]);
?>