<?php
session_start();
if (empty($_SESSION['logueado'])) {
    die(json_encode(['error' => 'No autenticado']));
}

require 'db.php';

header('Content-Type: application/json; charset=utf-8');

$query = $_GET['q'] ?? '';

if (strlen($query) < 2) {
    die(json_encode(['error' => 'Búsqueda muy corta']));
}

try {
    // Buscar en HTML, CSS y JS de todas las plantillas
    $stmt = $pdo->prepare("
        SELECT 
            pa.plantilla_id,
            p.nombre,
            pa.tipo,
            pa.contenido,
            CASE 
                WHEN pa.tipo = 'html' THEN 'HTML'
                WHEN pa.tipo = 'css' THEN 'CSS'
                WHEN pa.tipo = 'js' THEN 'JavaScript'
            END as tipo_nombre
        FROM plantilla_archivos pa
        JOIN plantillas p ON pa.plantilla_id = p.id
        WHERE pa.contenido LIKE ?
        ORDER BY pa.plantilla_id, pa.tipo
    ");
    
    $searchTerm = '%' . $query . '%';
    $stmt->execute([$searchTerm]);
    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (empty($resultados)) {
        echo json_encode(['resultados' => [], 'total' => 0]);
        exit;
    }
    
    // Agrupar por plantilla
    $agrupado = [];
    foreach ($resultados as $resultado) {
        $plantilla_id = $resultado['plantilla_id'];
        
        if (!isset($agrupado[$plantilla_id])) {
            $agrupado[$plantilla_id] = [
                'id' => $plantilla_id,
                'nombre' => $resultado['nombre'],
                'archivos' => []
            ];
        }
        
        // Encontrar posición de la búsqueda en el contenido
        $pos = stripos($resultado['contenido'], $query);
        $inicio = max(0, $pos - 50);
        $fin = min(strlen($resultado['contenido']), $pos + strlen($query) + 50);
        $preview = '...' . substr($resultado['contenido'], $inicio, $fin - $inicio) . '...';
        
        $agrupado[$plantilla_id]['archivos'][] = [
            'tipo' => $resultado['tipo_nombre'],
            'preview' => $preview,
            'posicion' => $pos
        ];
    }
    
    echo json_encode(['resultados' => array_values($agrupado), 'total' => count($agrupado)]);
    
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>