<?php
header("X-Frame-Options: ALLOWALL");
header("Access-Control-Allow-Origin: *");
header("Content-Type: text/html; charset=utf-8");

require 'db.php';

$plantilla_id = $_GET['id'] ?? 1;
$slug = $_GET['slug'] ?? '';

try {
    // ✅ OBTENER DATOS DE LA RADIO
    $api_url = 'https://playzonastore.com/app/api_funciones.php?accion=obtener_radio&slug=' . urlencode($slug);
    $response = @file_get_contents($api_url);
    $radio_data = $response ? json_decode($response, true) : [];
    
    // ✅ OBTENER PLANTILLA
    $stmt = $pdo->prepare("SELECT * FROM plantillas WHERE id=? AND activa=1");
    $stmt->execute([$plantilla_id]);
    $plantilla = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$plantilla) {
        die("Plantilla $plantilla_id no encontrada");
    }
    
    // ✅ OBTENER ARCHIVOS
    $stmt = $pdo->prepare("SELECT tipo, contenido FROM plantilla_archivos WHERE plantilla_id=?");
    $stmt->execute([$plantilla_id]);
    $archivos = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $html = '';
    $css = '';
    $js = '';
    
    foreach ($archivos as $archivo) {
        if ($archivo['tipo'] === 'html') {
            $html = $archivo['contenido'];
        } elseif ($archivo['tipo'] === 'css') {
            $css = $archivo['contenido'];
        } elseif ($archivo['tipo'] === 'js') {
            $js = $archivo['contenido'];
        }
    }
    
    // ✅ ARREGLAR RUTAS A ABSOLUTAS (SIN RESTRICCIONES)
    $basePlayzona = 'https://playzonastore.com';
    
    // Reemplazar en HTML
    $html = preg_replace_callback('/(src|href|data-src)=(["\'])([^"\']+)\2/i', function($m) use ($basePlayzona) {
        $attr = $m[1];
        $quote = $m[2];
        $url = $m[3];
        
        // Si ya es absoluta o data URL, dejar como está
        if (strpos($url, 'http') === 0 || strpos($url, 'data:') === 0 || strpos($url, '#') === 0) {
            return $m[0];
        }
        
        // Convertir relativa a absoluta
        $url = str_replace(['../', './'], '', $url);
        return $attr . '=' . $quote . $basePlayzona . '/' . ltrim($url, '/') . $quote;
    }, $html);
    
    // Reemplazar en CSS
    $css = preg_replace_callback('/url\(["\']?([^"\'()]+)["\']?\)/i', function($m) use ($basePlayzona) {
        $url = $m[1];
        
        if (strpos($url, 'http') === 0 || strpos($url, 'data:') === 0) {
            return $m[0];
        }
        
        $url = str_replace(['../', './'], '', $url);
        return 'url(' . $basePlayzona . '/' . ltrim($url, '/') . ')';
    }, $css);
    
    // ✅ REEMPLAZAR VARIABLES PHP (SOLO SI EXISTEN)
    if ($radio_data && $radio_data['ok']) {
        $urlBase = 'https://playzonastore.com/panel/uploads/radios/';
        
        $replacements = [
            "<?php echo NAME; ?>" => $radio_data['nombre'] ?? 'Radio',
            "<?php echo LEMA; ?>" => $radio_data['lema'] ?? '',
            "<?php echo LOGO; ?>" => $urlBase . ($radio_data['logo'] ?? ''),
            "<?php echo SLOGAN; ?>" => $radio_data['slogan'] ?? '',
            "<?php echo DESCRIPTION; ?>" => $radio_data['descripcion'] ?? '',
            "<?php echo URL_FACEBOOK; ?>" => $radio_data['url_facebook'] ?? '',
            "<?php echo URL_INSTAGRAM; ?>" => $radio_data['url_instagram'] ?? '',
            "<?php echo URL_TIKTOK; ?>" => $radio_data['url_tiktok'] ?? '',
            "<?php echo URL_YOUTUBE; ?>" => $radio_data['url_youtube'] ?? '',
            "<?php echo URL_WEBSITE; ?>" => $radio_data['url_website'] ?? '',
            "<?php echo URL_WHTASAPP; ?>" => $radio_data['url_whatsapp'] ?? '',
            "<?php echo URL_CHAT; ?>" => $radio_data['url_chat'] ?? '',
            "<?php echo FONDOAPP; ?>" => $urlBase . ($radio_data['fondoapp'] ?? ''),
            "<?php echo fONDOAPP; ?>" => $urlBase . ($radio_data['fondoapp'] ?? ''),
        ];
        
        foreach ($replacements as $php_var => $value) {
            if (!empty($value)) {
                $html = str_replace($php_var, $value, $html);
            }
        }
    }
    
    // ✅ VARIABLES GLOBALES (SIN RESTRICCIONES)
    $variables_js = "
    const slug = '" . addslashes($slug) . "';
    const plantilla_id = " . intval($plantilla_id) . ";
    const apiPlayzona = 'https://playzonastore.com/app/api_funciones.php';
    let idRadio = " . ($radio_data['ok'] ? intval($radio_data['id']) : 'null') . ";
    ";
    
    ?>
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?php echo ($radio_data['ok'] ? $radio_data['nombre'] : 'Radio'); ?></title>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
        <base href="https://playzonastore.com/">
        
        <style>
            <?php echo $css; ?>
        </style>
    </head>
    <body>
        <?php echo $html; ?>
        
        <script>
            <?php echo $variables_js; ?>
            <?php echo $js; ?>
        </script>
    </body>
    </html>
    <?php
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>

