<?php
require 'db.php';

header('Content-Type: text/html; charset=utf-8');

$plantilla_id = 1;
$slug = 'demomul';

echo "=== DEBUG PLANTILLA ===\n\n";

try {
    // Obtener plantilla
    $stmt = $pdo->prepare("SELECT * FROM plantillas WHERE id=?");
    $stmt->execute([$plantilla_id]);
    $plantilla = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "1. Plantilla encontrada: " . ($plantilla ? 'SÍ' : 'NO') . "\n";
    
    // Obtener archivos
    $stmt = $pdo->prepare("SELECT tipo, contenido FROM plantilla_archivos WHERE plantilla_id=?");
    $stmt->execute([$plantilla_id]);
    $archivos = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "2. Archivos encontrados: " . count($archivos) . "\n";
    
    foreach ($archivos as $archivo) {
        echo "   - " . $archivo['tipo'] . ": " . strlen($archivo['contenido']) . " bytes\n";
    }
    
    // Obtener HTML
    $html = '';
    foreach ($archivos as $archivo) {
        if ($archivo['tipo'] === 'html') {
            $html = $archivo['contenido'];
        }
    }
    
    echo "\n3. HTML obtenido: " . strlen($html) . " bytes\n";
    
    if (!empty($html)) {
        echo "\n4. Primeros 500 caracteres:\n";
        echo "<pre>" . htmlspecialchars(substr($html, 0, 500)) . "</pre>";
        
        echo "\n5. Verificar si tiene <?php:\n";
        if (strpos($html, '<?php') !== false) {
            echo "   ✅ SÍ tiene <?php\n";
        } else {
            echo "   ❌ NO tiene <?php\n";
        }
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage();
}

echo "\n\n=== AHORA ABRE EN IFRAME ===\n";
echo "<iframe src=\"https://proapi.zonaradio.in/cargar_plantilla_segura.php?id=1&slug=demomul\" style=\"width:100%; height:600px; border:1px solid red;\"></iframe>";
?>
```

Abre en navegador:
```
https://proapi.zonaradio.in/debug_plantilla.php