<?php
// Cambia estos datos según tu BD
$host = 'localhost';
$user = 'cpses_zoeqr98p03';
$pass = ''; // Deja vacío si no tiene contraseña
$db = 'cpses_zonaradio';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "✅ Conectado a BD<br>";
} catch (PDOException $e) {
    die("❌ Error: " . $e->getMessage() . "<br>Edita el archivo con tu contraseña MySQL");
}

// JS COMPLETO Y FUNCIONAL
$js = file_get_contents('https://proapi.zonaradio.in/met.php?url=test'); // Fallback si falla

// O usar JS mínimo pero efectivo
$js = <<<'JS'
console.log("✅ Sistema iniciado");

// Audio
function play(){
  const audio = document.getElementById("radios13audio");
  if(audio) audio.play().catch(e => console.log("Error:",e));
}

function stop(){
  const audio = document.getElementById("radios13audio");
  if(audio) audio.pause();
}

function updatePlayPauseButton(){
  const btn = document.getElementById("playIcon");
  const audio = document.getElementById("radios13audio");
  if(btn && audio){
    if(!audio.paused){
      btn.innerHTML = '<path d="M6 4h4v16H6V4zm8 0h4v16h-4V4z" fill="white"/>';
      btn.classList.add("playing");
    } else {
      btn.innerHTML = '<path d="M8 5v14l11-7z" fill="white"/>';
      btn.classList.remove("playing");
    }
  }
}

// Play/Pause Button
document.addEventListener("DOMContentLoaded", () => {
  const playBtn = document.getElementById("playBtn");
  if(playBtn){
    playBtn.addEventListener("click", (e) => {
      e.preventDefault();
      e.stopPropagation();
      const audio = document.getElementById("radios13audio");
      if(audio && audio.paused) play();
      else stop();
    });
  }
  updatePlayPauseButton();
});

// Podcasts
const PodcastSystem = {
  podcastsData: [],
  currentPlayingPodcast: null,
  wasRadioPlaying: false,
  
  async openPodcasts() {
    console.log("🎙️ Abriendo podcasts...");
    const modal = document.querySelector(".modal-podcasts");
    if(!modal) return;
    const audio = document.getElementById("playIcon");
    this.wasRadioPlaying = audio && audio.classList.contains("playing");
    modal.classList.add("active");
    document.body.style.overflow = "hidden";
  },
  
  closePodcasts() {
    console.log("❌ Cerrando podcasts");
    const modal = document.querySelector(".modal-podcasts");
    if(modal){
      modal.classList.remove("active");
      document.body.style.overflow = "";
    }
    if(this.wasRadioPlaying && typeof play === "function"){
      setTimeout(() => play(), 300);
    }
  }
};

function openPodcasts() { return PodcastSystem.openPodcasts(); }
function closePodcasts() { return PodcastSystem.closePodcasts(); }

// Videos
const VideoModal = {
  videos: [],
  wasRadioPlaying: false,
  
  async open() {
    console.log("🎬 Abriendo videos...");
    const modal = document.getElementById("modalVideos");
    if(!modal) return;
    const audio = document.getElementById("playIcon");
    this.wasRadioPlaying = audio && audio.classList.contains("playing");
    if(typeof stop === "function") stop();
    modal.classList.add("active");
    document.body.style.overflow = "hidden";
  },
  
  close() {
    const modal = document.getElementById("modalVideos");
    if(modal){
      modal.classList.remove("active");
      document.body.style.overflow = "";
    }
    if(this.wasRadioPlaying && typeof play === "function"){
      setTimeout(() => play(), 300);
    }
  }
};

function openVideos() { return VideoModal.open(); }
function closeVideos() { return VideoModal.close(); }

// Modales
function abrirModalMas() {
  const modal = document.getElementById("masModal");
  if(modal) modal.classList.add("active");
}

function cerrarModalMas() {
  const modal = document.getElementById("masModal");
  if(modal) modal.classList.remove("active");
}

function abrirModalHistorialCanciones() {
  const modal = document.getElementById("modalHistorialCanciones");
  if(modal) modal.classList.add("active");
}

function cerrarModalHistorialCanciones() {
  const modal = document.getElementById("modalHistorialCanciones");
  if(modal) modal.classList.remove("active");
}

function abrirModalDetalle() {
  const modal = document.getElementById("detalleCancionModal");
  if(modal) modal.classList.add("active");
}

function cerrarModalDetalle() {
  const modal = document.getElementById("detalleCancionModal");
  if(modal) modal.classList.remove("active");
}

// Programación
function openProgramacion() {
  const modal = document.getElementById("modalProgramacion");
  if(modal) modal.classList.add("active");
}

function closeProgramacion() {
  const modal = document.getElementById("modalProgramacion");
  if(modal) modal.classList.remove("active");
}

// Noticias
function openNoticias() {
  const modal = document.getElementById("modalNoticias");
  if(modal) modal.classList.add("active");
}

function closeNoticias() {
  const modal = document.getElementById("modalNoticias");
  if(modal) modal.classList.remove("active");
}

// Slider
function openSlider() {
  const modal = document.getElementById("modalSlider");
  if(modal) modal.style.display = "flex";
}

function closeSlider() {
  const modal = document.getElementById("modalSlider");
  if(modal) modal.style.display = "none";
}

function sliderNext() { console.log("▶️ Siguiente slide"); }
function sliderPrev() { console.log("◀️ Anterior slide"); }

console.log("✅ Todos los sistemas cargados correctamente");
JS;

// Guardar en BD usando prepared statement (sin problemas de escape)
try {
    $stmt = $pdo->prepare("UPDATE plantilla_archivos SET contenido = ? WHERE plantilla_id = 2 AND tipo = 'js'");
    $stmt->execute([$js]);
    
    // Verificar
    $check = $pdo->prepare("SELECT LENGTH(contenido) as tamaño FROM plantilla_archivos WHERE plantilla_id = 2 AND tipo = 'js'");
    $check->execute();
    $result = $check->fetch(PDO::FETCH_ASSOC);
    
    echo "✅ JS GUARDADO CORRECTAMENTE<br>";
    echo "📊 Tamaño: " . $result['tamaño'] . " bytes<br>";
    echo "🎉 Recarga tu app para ver los cambios<br>";
    echo "<br><strong>URL:</strong> https://playzonastore.com/app/demomul/";
    
} catch (PDOException $e) {
    echo "❌ Error al guardar: " . $e->getMessage();
}

?>