<?php
session_start();
// Si no está logueado, enviamos al login
if (empty($_SESSION['logueado'])) {
    header("Location: login.php");
    exit;
}
require 'db.php';

// Mostrar mensajes de sesión si existen
$mensaje_exito = $_SESSION['exito'] ?? null;
$mensaje_error = $_SESSION['error'] ?? null;
$mensaje_info = $_SESSION['info'] ?? null;

// Limpiar mensajes después de mostrarlos
if ($mensaje_exito) unset($_SESSION['exito']);
if ($mensaje_error) unset($_SESSION['error']);
if ($mensaje_info) unset($_SESSION['info']);

// ============ AGREGAR DESDE AQUÍ ============
// ============ CONFIGURACIÓN TOKENS (CAMBIAR ESTAS CLAVES) ============
define('ENCRYPTION_KEY', 'x9k2m1p0q8w3e5r2t9y4u1i3o5l7k9a6'); // ⚠️ CAMBIAR ESTO
define('ENCRYPTION_SALT', hash('sha256', 'zonastreaming-salt-secreto-rafael', true)); // ⚠️ CAMBIAR ESTO

// ============ BLOQUEAR BOTS Y SCRAPERS ============
$blocked_agents = ['HTTrack', 'Wget', 'Curl', 'urllib', 'scrapy', 'bot', 'crawler'];
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
foreach ($blocked_agents as $agent) {
    if (stripos($user_agent, $agent) !== false) {
        http_response_code(403);
        die(json_encode(['error' => 'Acceso denegado']));
    }
}

// ============ FUNCIONES DE TOKENS ============

function encryptContent($content) {
    $iv = openssl_random_pseudo_bytes(12);
    $tag = '';
    $encrypted = openssl_encrypt(
        $content,
        'aes-256-gcm',
        hash('sha256', ENCRYPTION_KEY, true),
        OPENSSL_RAW_DATA,
        $iv,
        $tag,
        hash('sha256', 'tu-salt-secreto-aqui', true)
    );
    return base64_encode($iv . $tag . $encrypted);
}

function generateToken($plantilla_id) {
    $data = $plantilla_id . session_id() . time() . $_SERVER['REMOTE_ADDR'];
    return hash('sha256', $data . ENCRYPTION_KEY);
}

function validateToken($plantilla_id, $token) {
    if (!isset($_SESSION['tokens'][$plantilla_id])) {
        return false;
    }
    
    $stored = $_SESSION['tokens'][$plantilla_id];
    
    if ($stored['token'] !== $token) {
        return false;
    }
    
    if (time() - $stored['created'] > 300) {
        unset($_SESSION['tokens'][$plantilla_id]);
        return false;
    }
    
    if ($stored['ip'] !== $_SERVER['REMOTE_ADDR']) {
        return false;
    }
    
    return true;
}

// ============ DETECTAR PETICIONES API ============
$is_api = !empty($_GET['api']);

if ($is_api) {
    header('Content-Type: application/json; charset=utf-8');
    
    $api_accion = $_GET['api'];
    $plantilla_id = $_GET['id'] ?? null;
    
    // OBTENER TOKEN
    if ($api_accion === 'obtener_token') {
        if (!$plantilla_id) {
            http_response_code(400);
            echo json_encode(['success' => false, 'error' => 'ID requerido']);
            exit;
        }
        
        $stmt = $pdo->prepare("SELECT id FROM plantillas WHERE id = ? AND activa = 1");
        $stmt->execute([$plantilla_id]);
        $plantilla = $stmt->fetch();
        
        if (!$plantilla) {
            http_response_code(404);
            echo json_encode(['success' => false, 'error' => 'Plantilla no encontrada']);
            exit;
        }
        
        $token = generateToken($plantilla_id);
        
        if (!isset($_SESSION['tokens'])) {
            $_SESSION['tokens'] = [];
        }
        
        $_SESSION['tokens'][$plantilla_id] = [
            'token' => $token,
            'created' => time(),
            'ip' => $_SERVER['REMOTE_ADDR'],
            'user_agent' => $user_agent
        ];
        
        echo json_encode([
            'success' => true,
            'token' => $token,
            'expires_in' => 300,
            'ip' => $_SERVER['REMOTE_ADDR']
        ]);
        exit;
    }
    
    // OBTENER CONTENIDO
    if ($api_accion === 'obtener_contenido') {
        $token = $_GET['token'] ?? null;
        $tipo = $_GET['tipo'] ?? 'html';
        
        if (!$token || !validateToken($plantilla_id, $token)) {
            http_response_code(401);
            echo json_encode(['success' => false, 'error' => 'Token inválido o expirado']);
            exit;
        }
        
        if (!in_array($tipo, ['html', 'css', 'js'])) {
            http_response_code(400);
            echo json_encode(['success' => false, 'error' => 'Tipo inválido']);
            exit;
        }
        
        $stmt = $pdo->prepare("SELECT id FROM plantillas WHERE id = ? AND activa = 1");
        $stmt->execute([$plantilla_id]);
        $plantilla = $stmt->fetch();
        
        if (!$plantilla) {
            http_response_code(404);
            echo json_encode(['success' => false, 'error' => 'Plantilla no encontrada']);
            exit;
        }
        
        $stmt = $pdo->prepare("SELECT contenido FROM plantilla_archivos WHERE plantilla_id = ? AND tipo = ?");
        $stmt->execute([$plantilla_id, $tipo]);
        $archivo = $stmt->fetch();
        
        $contenido = $archivo ? $archivo['contenido'] : "<!-- Contenido vacío -->";
        
        $encrypted = encryptContent($contenido);
        
        echo json_encode([
            'success' => true,
            'type' => $tipo,
            'contenido' => $contenido,
            'data' => $encrypted,
            'timestamp' => time()
        ]);
        exit;
    }
    
    http_response_code(400);
    echo json_encode(['error' => 'API no reconocida']);
    exit;
}

// ============ FIN CÓDIGO TOKENS - CONTINUAR CON LO DEMÁS ============

// Determinar qué sección mostrar
$seccion = $_GET['seccion'] ?? 'streamings';

// Cargar datos según la sección
if ($seccion === 'streamings') {
    $filtro = $_GET['filtro'] ?? 'all';
    
    if ($filtro === 'radio') {
        $streamings = $pdo->query("SELECT * FROM streamings WHERE tipo = 'radio' ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
    } elseif ($filtro === 'tv') {
        $streamings = $pdo->query("SELECT * FROM streamings WHERE tipo = 'tv' ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
    } else {
        $streamings = $pdo->query("SELECT * FROM streamings ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
    }
} elseif ($seccion === 'dominios') {
    $dominios = $pdo->query("SELECT * FROM dominios ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
} elseif ($seccion === 'plantillas') {
    $plantillas = $pdo->query("SELECT * FROM plantillas ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>ZonaStreaming - Panel de APIs</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="icon" type="image/icon" href="assets/icono.png">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--bg-color);
            color: var(--text-color);
            transition: all 0.3s ease;
        }
        
        :root {
            --bg-color: #0f0f23;
            --sidebar-bg: linear-gradient(180deg, #1a1a2e 0%, #16213e 100%);
            --text-color: #e4e4e7;
            --card-bg: #1a1a2e;
            --input-bg: #252540;
            --input-text: #e4e4e7;
            --border-color: rgba(139, 92, 246, 0.3);
            --accent-primary: #8b5cf6;
            --accent-secondary: #ec4899;
            --accent-success: #10b981;
            --accent-warning: #f59e0b;
            --accent-danger: #ef4444;
            --hover-bg: rgba(139, 92, 246, 0.1);
            --shadow: 0 4px 6px rgba(0, 0, 0, 0.3);
        }
        
        [data-theme="light"] {
            --bg-color: #f8fafc;
            --sidebar-bg: linear-gradient(180deg, #ffffff 0%, #f1f5f9 100%);
            --text-color: #1e293b;
            --card-bg: #ffffff;
            --input-bg: #f1f5f9;
            --input-text: #1e293b;
            --border-color: rgba(139, 92, 246, 0.2);
            --accent-primary: #8b5cf6;
            --accent-secondary: #ec4899;
            --accent-success: #10b981;
            --accent-warning: #f59e0b;
            --accent-danger: #ef4444;
            --hover-bg: rgba(139, 92, 246, 0.05);
            --shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        
        [data-theme="cosmic"] {
            --bg-color: #0a0e27;
            --sidebar-bg: linear-gradient(180deg, #1e2139 0%, #2d1b69 100%);
            --text-color: #e0e7ff;
            --card-bg: #1e2139;
            --input-bg: #2d1b69;
            --input-text: #e0e7ff;
            --border-color: rgba(99, 102, 241, 0.4);
            --accent-primary: #6366f1;
            --accent-secondary: #a855f7;
            --accent-success: #34d399;
            --accent-warning: #fbbf24;
            --accent-danger: #f87171;
            --hover-bg: rgba(99, 102, 241, 0.15);
            --shadow: 0 4px 6px rgba(99, 102, 241, 0.2);
        }

        [data-theme="ocean"] {
            --bg-color: #0c1e2e;
            --sidebar-bg: linear-gradient(180deg, #0f2a3f 0%, #1a4d6d 100%);
            --text-color: #e0f2fe;
            --card-bg: #0f2a3f;
            --input-bg: #1a4d6d;
            --input-text: #e0f2fe;
            --border-color: rgba(14, 165, 233, 0.4);
            --accent-primary: #0ea5e9;
            --accent-secondary: #06b6d4;
            --accent-success: #14b8a6;
            --accent-warning: #f59e0b;
            --accent-danger: #ef4444;
            --hover-bg: rgba(14, 165, 233, 0.15);
            --shadow: 0 4px 6px rgba(14, 165, 233, 0.2);
        }

        [data-theme="sunset"] {
            --bg-color: #1a0b15;
            --sidebar-bg: linear-gradient(180deg, #2d1b2e 0%, #4a1e3a 100%);
            --text-color: #fce7f3;
            --card-bg: #2d1b2e;
            --input-bg: #4a1e3a;
            --input-text: #fce7f3;
            --border-color: rgba(236, 72, 153, 0.4);
            --accent-primary: #ec4899;
            --accent-secondary: #f97316;
            --accent-success: #10b981;
            --accent-warning: #fbbf24;
            --accent-danger: #ef4444;
            --hover-bg: rgba(236, 72, 153, 0.15);
            --shadow: 0 4px 6px rgba(236, 72, 153, 0.2);
        }
        
        .sidebar {
            width: 280px;
            background: var(--sidebar-bg);
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            padding: 25px 0;
            transition: all 0.3s ease;
            overflow-y: auto;
            box-shadow: 4px 0 15px rgba(0, 0, 0, 0.2);
            z-index: 1000;
        }
        
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }
        
        .sidebar::-webkit-scrollbar-track {
            background: transparent;
        }
        
        .sidebar::-webkit-scrollbar-thumb {
            background: var(--accent-primary);
            border-radius: 10px;
        }
        
        .sidebar img {
            display: block;
            margin: 0 auto 25px;
            max-width: 180px;
            filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.3));
        }
        
        .sidebar a {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 10px 25px;
            color: var(--text-color);
            text-decoration: none;
            opacity: 0.85;
            transition: all 0.3s ease;
            margin: 4px 12px;
            border-radius: 10px;
            font-weight: 500;
        }
        
        .sidebar a i {
            font-size: 18px;
            min-width: 20px;
        }
        
        .sidebar a:hover {
            background: var(--hover-bg);
            opacity: 1;
            transform: translateX(5px);
        }
        
        .sidebar a.active {
            background: var(--accent-primary);
            color: white;
            opacity: 1;
            box-shadow: 0 4px 12px rgba(139, 92, 246, 0.4);
        }
        
        .sidebar a[style*="color:#f55"] {
            color: var(--accent-danger) !important;
            margin-top: 20px;
        }
        
        .sidebar a[style*="color:#f55"]:hover {
            background: rgba(239, 68, 68, 0.1);
        }
        
        .topbar {
            height: 70px;
            background: var(--card-bg);
            margin-left: 280px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 30px;
            border-bottom: 2px solid var(--border-color);
            transition: all 0.3s ease;
            backdrop-filter: blur(10px);
            box-shadow: var(--shadow);
        }
        
        .theme-selector {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .theme-selector label {
            font-weight: 600;
            color: var(--text-color);
            font-size: 14px;
        }
        
        .theme-select {
            background: var(--input-bg);
            color: var(--input-text);
            border: 2px solid var(--border-color);
            padding: 8px 16px;
            border-radius: 10px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .theme-select option {
            background: var(--input-bg);
            color: var(--input-text);
        }
        
        .theme-select:hover {
            border-color: var(--accent-primary);
            box-shadow: 0 0 0 3px var(--hover-bg);
        }
        
        .theme-select:focus {
            outline: none;
            border-color: var(--accent-primary);
            box-shadow: 0 0 0 3px var(--hover-bg);
        }
        
        .support-info {
            display: flex;
            align-items: center;
            gap: 20px;
            color: var(--text-color);
        }
        
        .support-info i {
            font-size: 16px;
            color: var(--accent-primary);
        }
        
        .support-info > span {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
            padding: 8px 16px;
            background: var(--hover-bg);
            border-radius: 8px;
        }
        
        .avatar {
            background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));
            color: white;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 16px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }
        
        .content {
            margin-left: 280px;
            padding: 30px;
            padding-bottom: 100px;
            min-height: calc(100vh - 70px);
        }
        
        .content h2 {
            margin-bottom: 25px;
            font-weight: 700;
            color: var(--text-color);
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .content h2 i {
            color: var(--accent-primary);
        }
        
        .card {
            background: var(--card-bg);
            border-radius: 16px;
            box-shadow: var(--shadow);
            border: 1px solid var(--border-color);
            transition: all 0.3s ease;
        }
        
        .card:hover {
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
        }
        
        input, select, button, textarea {
            background-color: var(--input-bg) !important;
            color: var(--input-text) !important;
            border: 2px solid var(--border-color) !important;
            border-radius: 10px !important;
            transition: all 0.3s ease;
        }
        
        input:focus, select:focus, textarea:focus {
            outline: none !important;
            border-color: var(--accent-primary) !important;
            box-shadow: 0 0 0 3px var(--hover-bg) !important;
        }
        
        .btn-outline-primary {
            background: transparent !important;
            color: var(--accent-primary) !important;
            border: 2px solid var(--accent-primary) !important;
        }
        
        .btn-outline-primary:hover {
            background: var(--accent-primary) !important;
            color: white !important;
        }
        
        .btn-outline-primary.active {
            background: var(--accent-primary) !important;
            color: white !important;
        }
        
        .btn-group {
            box-shadow: var(--shadow);
            border-radius: 10px;
            overflow: hidden;
        }
        
        .btn {
            font-weight: 600;
            border-radius: 10px !important;
            padding: 8px 16px;
            transition: all 0.3s ease;
            border: none !important;
        }
        
        .btn-success {
            background: var(--accent-success) !important;
            color: white !important;
        }
        
        .btn-success:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(16, 185, 129, 0.4) !important;
        }
        
        .btn-primary {
            background: var(--accent-primary) !important;
            color: white !important;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(139, 92, 246, 0.4) !important;
        }
        
        .btn-warning {
            background: var(--accent-warning) !important;
            color: white !important;
        }
        
        .btn-warning:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(245, 158, 11, 0.4) !important;
        }
        
        .btn-danger {
            background: var(--accent-danger) !important;
            color: white !important;
        }
        
        .btn-danger:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(239, 68, 68, 0.4) !important;
        }
        
        .table {
            color: var(--text-color);
            border-radius: 12px;
            overflow: hidden;
        }
        
        .table thead {
            background: var(--accent-primary);
            color: white;
        }
        
        .table tbody tr {
            transition: all 0.2s ease;
        }
        
        .table tbody tr:hover {
            background: var(--hover-bg);
        }
        
        .badge {
            padding: 6px 14px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 12px;
        }
        
        footer {
            position: fixed;
            bottom: 0;
            left: 280px;
            width: calc(100% - 280px);
            background: var(--card-bg);
            color: var(--text-color);
            padding: 15px 30px;
            font-size: 14px;
            border-top: 2px solid var(--border-color);
            display: flex;
            justify-content: space-between;
            align-items: center;
            backdrop-filter: blur(10px);
            box-shadow: 0 -4px 15px rgba(0, 0, 0, 0.1);
        }
        
        .social-icons a {
            color: var(--text-color);
            margin-left: 15px;
            font-size: 22px;
            transition: all 0.3s ease;
            display: inline-block;
        }
        
        .social-icons a:hover {
            color: var(--accent-primary);
            transform: translateY(-3px);
        }
        
        .modal-content {
            background-color: var(--card-bg) !important;
            color: var(--text-color) !important;
            border: 2px solid var(--border-color) !important;
            border-radius: 16px !important;
        }
        
        .modal-header {
            border-bottom: 2px solid var(--border-color) !important;
            background: var(--hover-bg);
        }
        
        .modal-footer {
            border-top: 2px solid var(--border-color) !important;
            background: var(--hover-bg);
        }
        
        .btn-close {
            filter: invert(1);
        }
        
        [data-theme="light"] .btn-close {
            filter: invert(0);
        }
        
        .text-muted {
            color: var(--text-color);
            opacity: 0.7;
        }

        .form-label {
            font-weight: 600;
            margin-bottom: 8px;
            color: var(--text-color);
        }

        .alert {
            border-radius: 12px !important;
            border: none !important;
        }

        .pin-badge {
            background: var(--accent-primary);
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-weight: 700;
            font-size: 16px;
            font-family: 'Courier New', monospace;
            letter-spacing: 2px;
        }
    </style>
</head>


<body data-theme="cosmic">

    <div class="sidebar">
        <img src="assets/logo.png" alt="Logo">
        <a href="index.php?seccion=streamings" class="<?= $seccion === 'streamings' ? 'active' : '' ?>"
        style="font-size: 14px;">
            <i class="bi bi-broadcast"></i> Streamings
        </a>
        <a href="index.php?seccion=dominios" class="<?= $seccion === 'dominios' ? 'active' : '' ?>"
        style="font-size: 14px;">
            <i class="bi bi-globe"></i> Dominios Autorizados
        </a>
        <a href="index.php?seccion=plantillas" 
        class="<?= $seccion === 'plantillas' ? 'active' : '' ?>" 
        style="font-size: 14px;">
        <i class="bi bi-palette"></i> Plantillas (HTML/CSS/JS)
       </a>
       <a href="index.php?seccion=notas" class="<?= $seccion === 'notas' ? 'active' : '' ?>"
        style="font-size: 14px;">
        <i class="bi bi-sticky"></i> Notas
        </a>
     
        <a href="index.php?seccion=perfil" class="<?= $seccion === 'perfil' ? 'active' : '' ?>"
        style="font-size: 14px;">
            <i class="bi bi-person-circle"></i> Mi Perfil
        </a>
        <a href="index.php?seccion=password" class="<?= $seccion === 'password' ? 'active' : '' ?>"
        style="font-size: 14px;">
            <i class="bi bi-key"></i> Cambiar Contraseña
        </a>
        <a href="logout.php" style="color:#f55;font-size: 14px;">
            <i class="bi bi-box-arrow-right"></i> Cerrar Sesión
        </a>
    </div>

    <div class="topbar">
        <div>
            <label for="theme">Elegir tema: </label>
            <select id="theme" class="theme-select">
              <option value="light">☀️ Light</option>
              <option value="dark">🌙 Dark</option>
              <option value="cosmic" selected>🌌 Cosmic</option>
              <option value="ocean">🌊 Ocean</option>
              <option value="sunset">🌅 Sunset</option>
            </select>
        </div>

        <div class="support-info">
            <span><i class="bi bi-envelope"></i> Soporte: ochoarafael611@gmail.com</span>
            <div class="d-flex align-items-center gap-2">
                <div class="avatar">A</div>
                <span>Administrador</span>
            </div>
        </div>
    </div>
    
    

    <div class="content">
      <?php if ($seccion === 'plantillas'): ?>
            <!-- SECCIÓN PLANTILLAS CON TOKENS Y ENCRIPTACIÓN -->
            <h2><i class="bi bi-palette"></i> Plantillas (HTML/CSS/JS)</h2>
            <p class="text-muted">Crea y gestiona plantillas de código con PIN seguro y encriptación</p>
            
            <!-- CREAR NUEVA PLANTILLA -->
            <div class="card p-4 mb-4">
                <h5 class="mb-3"><i class="bi bi-plus-circle"></i> Crear Nueva Plantilla</h5>
                <form class="mb-3" method="POST" action="accion_plantillas.php">
                    <input type="hidden" name="accion" value="agregar">
                    <div class="row g-2">
                        <div class="col-md-3">
                            <input type="text" name="nombre" class="form-control" placeholder="Nombre de la plantilla" required>
                        </div>
                        <div class="col-md-2">
                            <input type="text" name="dominio" class="form-control" placeholder="ejemplo.com" required>
                        </div>
                        <div class="col-md-3">
                            <input type="text" name="descripcion" class="form-control" placeholder="Descripción (opcional)">
                        </div>
                        <div class="col-md-2">
                            <select name="tipo" class="form-select" required>
                                <option value="">Seleccionar tipo</option>
                                <option value="html">HTML</option>
                                <option value="css">CSS</option>
                                <option value="js">JavaScript</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button type="submit" class="btn btn-success w-100"><i class="bi bi-plus-circle"></i> Crear</button>
                        </div>
                    </div>
                </form>
            </div>

            <!-- LISTA DE PLANTILLAS -->
            <div class="card p-3">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th style="width: 80px;">Nº</th>
                            <th>Nombre</th>
                            <th>Dominio</th>
                            <th>PIN Seguro</th>
                            <th>Descripción</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($plantillas)): ?>
                            <?php $contador = 1; foreach($plantillas as $p): ?>
                            <?php 
                                $estadoTexto = $p['activa'] ? 'Activa' : 'Inactiva';
                                $estadoClase = $p['activa'] ? 'success' : 'secondary';
                            ?>
                            <tr>
                                <td><strong class="text-primary" style="font-size: 16px;"><?= $contador ?></strong></td>
                                <td><strong><?= htmlspecialchars($p['nombre']) ?></strong></td>
                                <td><code><?= htmlspecialchars($p['dominio']) ?></code></td>
                                <td>
                                    <span class="pin-badge" title="PIN: <?= htmlspecialchars($p['pin']) ?>">
                                        <?= htmlspecialchars($p['pin']) ?>
                                    </span>
                                </td>
                                <td><?= htmlspecialchars($p['descripcion'] ?? '-') ?></td>
                                <td>
                                    <span class="badge bg-<?= $estadoClase ?>">
                                        <?= $estadoTexto ?>
                                    </span>
                                </td>
                                <td>
                                    <!-- BOTÓN EDITAR CAMPOS -->
                                    <button type="button" class="btn btn-secondary btn-sm" title="Editar información" onclick="abrirModalEditar(<?= $p['id'] ?>, '<?= htmlspecialchars($p['nombre'], ENT_QUOTES) ?>', '<?= htmlspecialchars($p['dominio'], ENT_QUOTES) ?>', '<?= htmlspecialchars($p['descripcion'] ?? '', ENT_QUOTES) ?>')">
                                        <i class="bi bi-pencil-square"></i> Editar Info
                                    </button>

                                    <a href="editor_plantilla.php?id=<?= $p['id'] ?>" class="btn btn-primary btn-sm" title="Editar plantilla">
                                        <i class="bi bi-pencil"></i> Editar
                                    </a>
                                    
                                    <!-- BOTÓN OBTENER TOKEN -->
                                    <button type="button" class="btn btn-info btn-sm" title="Obtener token de acceso" onclick="obtenerToken(<?= $p['id'] ?>, <?= $contador ?>, '<?= htmlspecialchars($p['nombre'], ENT_QUOTES) ?>')">
                                        <i class="bi bi-key"></i> Token
                                    </button>
                                    
                                    <?php if(!$p['activa']): ?>
                                        <a href="accion_plantillas.php?accion=activar&id=<?= $p['id'] ?>" class="btn btn-success btn-sm">
                                            <i class="bi bi-check-circle"></i> Activar
                                        </a>
                                    <?php else: ?>
                                        <a href="accion_plantillas.php?accion=desactivar&id=<?= $p['id'] ?>" class="btn btn-warning btn-sm">
                                            <i class="bi bi-x-circle"></i> Desactivar
                                        </a>
                                    <?php endif; ?>
                                    
                                    <a href="accion_plantillas.php?accion=eliminar&id=<?= $p['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Eliminar plantilla?')">
                                        <i class="bi bi-trash"></i> Eliminar
                                    </a>
                                </td>
                            </tr>
                            <?php $contador++; endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted py-5">
                                    <i class="bi bi-inbox" style="font-size: 32px; opacity: 0.5;"></i><br>
                                    No hay plantillas creadas
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- MODAL: EDITAR INFORMACIÓN -->
            <div class="modal fade" id="modalEditarInfo" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">
                                <i class="bi bi-pencil-square"></i> Editar Información
                            </h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <form method="POST" action="accion_plantillas.php">
                            <input type="hidden" name="accion" value="editar_info">
                            <input type="hidden" name="id" id="editar-id">
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label class="form-label"><strong>Nombre de la Plantilla:</strong></label>
                                    <input type="text" class="form-control" name="nombre" id="editar-nombre" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label"><strong>Dominio:</strong></label>
                                    <input type="text" class="form-control" name="dominio" id="editar-dominio" placeholder="ejemplo.com" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label"><strong>Descripción:</strong></label>
                                    <textarea class="form-control" name="descripcion" id="editar-descripcion" rows="3"></textarea>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-check-circle"></i> Guardar Cambios
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- MODAL: OBTENER TOKEN -->
            <div class="modal fade" id="modalObtenerToken" tabindex="-1">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">
                                <i class="bi bi-key"></i> Token de Acceso - Plantilla <span id="token-plantilla-numero"></span>: <span id="token-plantilla-nombre"></span>
                            </h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <div class="alert alert-warning">
                                <i class="bi bi-info-circle"></i> 
                                <strong>Token generado en el servidor</strong> - Válido por 5 minutos. Se vincula a tu IP y User-Agent actual.
                            </div>
                            
                            <!-- INFORMACIÓN DEL TOKEN -->
                            <div class="mb-3">
                                <label class="form-label"><strong>Token Backend (Servidor):</strong></label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="token-valor" readonly style="font-family: monospace; font-size: 11px;">
                                    <button class="btn btn-primary" type="button" onclick="copiarAlPortapapeles('token-valor')">
                                        <i class="bi bi-clipboard"></i> Copiar
                                    </button>
                                </div>
                            </div>
                            
                            <!-- INFORMACIÓN DE VALIDACIÓN -->
                            <div class="mb-3">
                                <label class="form-label"><strong>Validaciones Activas:</strong></label>
                                <ul class="list-group">
                                    <li class="list-group-item">
                                        <i class="bi bi-shield-check text-success"></i> 
                                        IP validada: <code id="token-ip"></code>
                                    </li>
                                    <li class="list-group-item">
                                        <i class="bi bi-shield-check text-success"></i> 
                                        User-Agent validado
                                    </li>
                                    <li class="list-group-item">
                                        <i class="bi bi-clock text-warning"></i> 
                                        Válido por: <strong>5 minutos</strong>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                            <button type="button" class="btn btn-success" onclick="descargarHTML()">
                                <i class="bi bi-download"></i> Descargar HTML
                            </button>
                            <button type="button" class="btn btn-info" onclick="descargarCSS()">
                                <i class="bi bi-download"></i> Descargar CSS
                            </button>
                            <button type="button" class="btn btn-warning" onclick="descargarJS()">
                                <i class="bi bi-download"></i> Descargar JS
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- MODAL: DESCARGAR CONTENIDO -->
            <div class="modal fade" id="modalDescargarContenido" tabindex="-1">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">
                                <i class="bi bi-download"></i> Descargar - <span id="titulo-descarga"></span>
                            </h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <div id="logs-descarga" class="alert alert-light" style="background: var(--input-bg); max-height: 300px; overflow-y: auto; font-family: monospace; font-size: 12px;">
                                <div class="text-muted">Esperando descargar...</div>
                            </div>
                            
                            <div class="mt-3">
                                <label class="form-label"><strong>Contenido Desencriptado:</strong></label>
                                <textarea class="form-control" id="contenido-descargado" rows="12" readonly style="font-family: 'Courier New', monospace; font-size: 12px;"></textarea>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                            <button type="button" class="btn btn-primary" onclick="copiarAlPortapapeles('contenido-descargado')">
                                <i class="bi bi-clipboard"></i> Copiar Contenido
                            </button>
                            <button type="button" class="btn btn-success" onclick="descargarArchivo()">
                                <i class="bi bi-download"></i> Descargar Archivo
                            </button>
                        </div>
                    </div>
                </div>
            </div>


        <?php elseif ($seccion === 'streamings'): ?>
            <!-- SECCIÓN STREAMINGS (CÓDIGO ORIGINAL) -->
            <h2><i class="bi bi-broadcast"></i> Lista de Streamings</h2>
            
            <!-- Filtros de tipo -->
            <div class="mb-3">
                <div class="btn-group" role="group">
                    <a href="index.php?seccion=streamings" class="btn btn-outline-primary <?= !isset($_GET['filtro']) ? 'active' : '' ?>">
                        <i class="bi bi-list"></i> Todos
                    </a>
                    <a href="index.php?seccion=streamings&filtro=radio" class="btn btn-outline-primary <?= ($_GET['filtro'] ?? '') === 'radio' ? 'active' : '' ?>">
                        <i class="bi bi-broadcast-pin"></i> Radios
                    </a>
                    <a href="index.php?seccion=streamings&filtro=tv" class="btn btn-outline-primary <?= ($_GET['filtro'] ?? '') === 'tv' ? 'active' : '' ?>">
                        <i class="bi bi-tv"></i> TVs
                    </a>
                </div>
            </div>

            <form class="mb-3" method="POST" action="accion_streamings.php">
                <input type="hidden" name="accion" value="agregar">
                <div class="row g-2">
                    <div class="col-md-3">
                        <input type="text" name="nombre" class="form-control" placeholder="Nombre del streaming" required>
                    </div>
                    <div class="col-md-4">
                        <input type="text" name="url" class="form-control" placeholder="URL del Streaming" required>
                    </div>
                    <div class="col-md-2">
                        <select name="tipo" class="form-select" required>
                            <option value="radio">Radio</option>
                            <option value="tv">TV</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <button class="btn btn-success w-100"><i class="bi bi-plus-circle"></i> Agregar</button>
                    </div>
                </div>
            </form>

            <div class="card p-3">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Nombre</th>
                            <th>URL</th>
                            <th>Tipo</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($streamings as $s): ?>
                        <?php 
                            $estadoTexto = ($s['estado'] === 'activo') ? 'Activo' : 'Suspendido';
                            $estadoClase = ($s['estado'] === 'activo') ? 'success' : 'secondary';
                        ?>
                        <tr>
                            <td><?= htmlspecialchars($s['nombre'] ?? 'Sin nombre') ?></td>
                            <td><?= htmlspecialchars($s['url']) ?></td>
                            <td><span class="badge bg-info"><?= ucfirst($s['tipo']) ?></span></td>
                            <td>
                                <span class="badge bg-<?= $estadoClase ?>">
                                    <?= $estadoTexto ?>
                                </span>
                            </td>
                            <td>
                                <button class="btn btn-primary btn-sm" onclick="editarStreaming(<?= $s['id'] ?>, '<?= htmlspecialchars($s['nombre'] ?? '', ENT_QUOTES) ?>', '<?= htmlspecialchars($s['url'], ENT_QUOTES) ?>', '<?= $s['tipo'] ?>')">
                                    <i class="bi bi-pencil"></i> Editar
                                </button>
                                <?php if($s['estado'] === 'activo'): ?>
                                    <a href="accion_streamings.php?accion=suspender&id=<?= $s['id'] ?>" class="btn btn-warning btn-sm">
                                        <i class="bi bi-pause-circle"></i> Suspender
                                    </a>
                                <?php else: ?>
                                    <a href="accion_streamings.php?accion=activar&id=<?= $s['id'] ?>" class="btn btn-success btn-sm">
                                        <i class="bi bi-play-circle"></i> Activar
                                    </a>
                                <?php endif; ?>
                                <a href="accion_streamings.php?accion=eliminar&id=<?= $s['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Eliminar streaming?')">
                                    <i class="bi bi-trash"></i> Eliminar
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Modal Editar Streaming -->
            <div class="modal fade" id="modalEditarStreaming" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title"><i class="bi bi-pencil"></i> Editar Streaming</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <form method="POST" action="accion_streamings.php">
                            <div class="modal-body">
                                <input type="hidden" name="accion" value="editar">
                                <input type="hidden" name="id" id="edit_streaming_id">
                                
                                <div class="mb-3">
                                    <label class="form-label">Nombre</label>
                                    <input type="text" name="nombre" id="edit_streaming_nombre" class="form-control" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">URL</label>
                                    <input type="text" name="url" id="edit_streaming_url" class="form-control" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Tipo</label>
                                    <select name="tipo" id="edit_streaming_tipo" class="form-select" required>
                                        <option value="radio">Radio</option>
                                        <option value="tv">TV</option>
                                    </select>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-save"></i> Guardar Cambios
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        <?php elseif ($seccion === 'dominios'): ?>
            <!-- SECCIÓN DOMINIOS AUTORIZADOS -->
            <h2><i class="bi bi-globe"></i> Dominios Autorizados</h2>
            <p class="text-muted">Solo los dominios autorizados podrán acceder a tus APIs</p>
            
            <form class="mb-3" method="POST" action="accion_dominios.php">
                <input type="hidden" name="accion" value="agregar">
                <div class="row g-2">
                    <div class="col-md-5">
                        <input type="text" name="nombre" class="form-control" placeholder="Nombre del sitio" required>
                    </div>
                    <div class="col-md-4">
                        <input type="text" name="dominio" class="form-control" placeholder="ejemplo.com" required>
                    </div>
                    <div class="col-md-3">
                        <button class="btn btn-success w-100"><i class="bi bi-plus-circle"></i> Agregar Dominio</button>
                    </div>
                </div>
            </form>

            <div class="card p-3">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Nombre</th>
                            <th>Dominio</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($dominios as $d): ?>
                        <?php 
                            $estadoTexto = ($d['estado'] === 'activo') ? 'Activo' : 'Bloqueado';
                            $estadoClase = ($d['estado'] === 'activo') ? 'success' : 'danger';
                        ?>
                        <tr>
                            <td><?= htmlspecialchars($d['nombre'] ?? 'Sin nombre') ?></td>
                            <td><code><?= htmlspecialchars($d['dominio']) ?></code></td>
                            <td>
                                <span class="badge bg-<?= $estadoClase ?>">
                                    <?= $estadoTexto ?>
                                </span>
                            </td>
                            <td>
                                <button class="btn btn-primary btn-sm" onclick="editarDominio(<?= $d['id'] ?>, '<?= htmlspecialchars($d['nombre'] ?? '', ENT_QUOTES) ?>', '<?= htmlspecialchars($d['dominio'], ENT_QUOTES) ?>')">
                                    <i class="bi bi-pencil"></i> Editar
                                </button>
                                <?php if($d['estado'] === 'activo'): ?>
                                    <a href="accion_dominios.php?accion=bloquear&id=<?= $d['id'] ?>" class="btn btn-warning btn-sm">
                                        <i class="bi bi-lock"></i> Bloquear
                                    </a>
                                <?php else: ?>
                                    <a href="accion_dominios.php?accion=activar&id=<?= $d['id'] ?>" class="btn btn-success btn-sm">
                                        <i class="bi bi-unlock"></i> Desbloquear
                                    </a>
                                <?php endif; ?>
                                <a href="accion_dominios.php?accion=eliminar&id=<?= $d['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Eliminar este dominio?')">
                                    <i class="bi bi-trash"></i> Eliminar
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Modal Editar Dominio -->
            <div class="modal fade" id="modalEditarDominio" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title"><i class="bi bi-pencil"></i> Editar Dominio</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <form method="POST" action="accion_dominios.php">
                            <div class="modal-body">
                                <input type="hidden" name="accion" value="editar">
                                <input type="hidden" name="id" id="edit_dominio_id">
                                
                                <div class="mb-3">
                                    <label class="form-label">Nombre del Sitio</label>
                                    <input type="text" name="nombre" id="edit_dominio_nombre" class="form-control" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Dominio</label>
                                    <input type="text" name="dominio" id="edit_dominio_dominio" class="form-control" placeholder="ejemplo.com" required>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-save"></i> Guardar Cambios
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            
           
               
               
                
          <?php elseif ($seccion === 'notas'): ?>
                    <!-- SECCIÓN NOTAS CON BASE DE DATOS -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <h2><i class="bi bi-sticky"></i> Mis Notas</h2>
                            <p class="text-muted">Organiza tus notas por categorías y búscalas fácilmente</p>
                        </div>
                    </div>
                
                    <!-- BUSCADOR Y FILTROS -->
                    <div class="card p-4 mb-4">
                        <div class="row g-3 align-items-end">
                            <div class="col-md-5">
                                <label class="form-label"><strong>🔍 Buscar notas:</strong></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-search"></i></span>
                                    <input type="text" class="form-control" id="inputBusqueda" placeholder="Buscar por título o contenido...">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label"><strong>📁 Categoría:</strong></label>
                                <select class="form-select" id="selectCategoria">
                                    <option value="todas">Todas las categorías</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">&nbsp;</label>
                                <button class="btn btn-primary w-100" onclick="buscarNotas()">
                                    <i class="bi bi-search"></i> Buscar
                                </button>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">&nbsp;</label>
                                <button class="btn btn-success w-100" onclick="abrirModalNota()">
                                    <i class="bi bi-plus-circle"></i> Nueva
                                </button>
                            </div>
                        </div>
                    </div>
                
                    <!-- LISTA DE NOTAS EN TRES COLUMNAS (LARGAS) -->
                    <div id="contenedorNotas" style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 20px; padding: 15px 0;">
                        <div class="text-center text-muted py-5" style="width: 100%; grid-column: 1 / -1;">
                            <i class="bi bi-inbox" style="font-size: 48px; opacity: 0.3;"></i>
                            <p>Cargando notas...</p>
                        </div>
                    </div>
                
                    <style>
                        .card-nota {
                            display: flex;
                            flex-direction: column;
                            height: 100%;
                            min-height: 160px;
                            padding: 14px;
                            border-left: 5px solid;
                            border-radius: 12px;
                            transition: all 0.3s ease;
                            cursor: pointer;
                        }
                        
                        .card-nota:hover {
                            transform: translateY(-4px);
                            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
                        }
                        
                        .card-nota-content {
                            flex: 1;
                            display: flex;
                            flex-direction: column;
                        }
                        
                        .card-nota-titulo {
                            font-weight: 700;
                            font-size: 14px;
                            margin-bottom: 6px;
                            word-wrap: break-word;
                            line-height: 1.2;
                        }
                        
                        .card-nota-texto {
                            font-size: 12px;
                            opacity: 0.8;
                            margin-bottom: 8px;
                            flex: 1;
                            word-wrap: break-word;
                            line-height: 1.4;
                            overflow: hidden;
                            display: -webkit-box;
                            -webkit-line-clamp: 2;
                            -webkit-box-orient: vertical;
                        }
                        
                        .card-nota-footer {
                            display: flex;
                            justify-content: space-between;
                            align-items: center;
                            font-size: 10px;
                            margin-bottom: 8px;
                            padding-top: 6px;
                            border-top: 1px solid rgba(255, 255, 255, 0.1);
                            gap: 6px;
                        }
                        
                        .card-nota-footer .badge {
                            font-size: 9px;
                            padding: 3px 8px;
                        }
                        
                        .card-nota-acciones {
                            display: flex;
                            gap: 6px;
                        }
                        
                        .card-nota-acciones .btn {
                            flex: 1;
                            padding: 5px 8px;
                            font-size: 11px;
                        }
                    </style>
                
                    <!-- MODAL: CREAR/EDITAR NOTA -->
                    <div class="modal fade" id="modalNota" tabindex="-1">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">
                                        <i class="bi bi-sticky"></i> <span id="tituloModal">Nueva Nota</span>
                                    </h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <form id="formNota">
                                    <input type="hidden" id="notaId">
                                    <div class="modal-body">
                                        <div class="mb-3">
                                            <label class="form-label"><strong>Título:</strong></label>
                                            <input type="text" class="form-control" id="notaTitulo" placeholder="Título de la nota" required>
                                        </div>
                                        <div class="row g-3 mb-3">
                                            <div class="col-md-6">
                                                <label class="form-label"><strong>Categoría:</strong></label>
                                                <select class="form-select" id="notaCategoria" required>
                                                    <option value="General">General</option>
                                                </select>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label"><strong>Color:</strong></label>
                                                <div class="d-flex gap-2">
                                                    <input type="color" class="form-control" id="notaColor" value="#8b5cf6" style="width: 50px;">
                                                    <span id="colorPreview" style="display: inline-block; width: 50px; border-radius: 8px; background: #8b5cf6;"></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label"><strong>Contenido:</strong></label>
                                            <textarea class="form-control" id="notaContenido" placeholder="Escribe el contenido de la nota..." rows="8" required></textarea>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bi bi-save"></i> Guardar Nota
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                
                    <!-- MODAL: VER NOTA COMPLETA -->
                    <div class="modal fade" id="modalVerNota" tabindex="-1">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header" id="verNotaHeader">
                                    <h5 class="modal-title" id="verNotaTitulo">Nota</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="mb-3">
                                        <small class="text-muted">
                                            <i class="bi bi-clock"></i> Actualizada: <span id="verNotaFecha"></span>
                                        </small>
                                        <br>
                                        <span class="badge" id="verNotaBadge" style="margin-top: 8px;"></span>
                                    </div>
                                    <div id="verNotaContenido" style="white-space: pre-wrap; line-height: 1.6; font-size: 15px;"></div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-warning" onclick="editarNotaActual()">
                                        <i class="bi bi-pencil"></i> Editar
                                    </button>
                                    <button type="button" class="btn btn-danger" onclick="eliminarNotaActual()">
                                        <i class="bi bi-trash"></i> Eliminar
                                    </button>
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                                </div>
                            </div>
                        </div>
                    </div>





        <?php elseif ($seccion === 'perfil'): ?>
            <!-- SECCIÓN PERFIL -->
            <h2><i class="bi bi-person-circle"></i> Mi Perfil</h2>
            
            <?php if (isset($_GET['msg'])): ?>
                <div class="alert alert-<?= $_GET['tipo'] ?? 'info' ?> alert-dismissible fade show">
                    <?= htmlspecialchars($_GET['msg']) ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="card p-4">
                <form method="POST" action="accion_perfil.php">
                    <input type="hidden" name="accion" value="actualizar_usuario">
                    <div class="mb-3">
                        <label class="form-label">Usuario Actual</label>
                        <input type="text" class="form-control" value="<?= htmlspecialchars($_SESSION['usuario'] ?? 'admin') ?>" disabled>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Nuevo Usuario</label>
                        <input type="text" name="nuevo_usuario" class="form-control" placeholder="Ingrese nuevo nombre de usuario" required>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save"></i> Actualizar Usuario
                    </button>
                </form>
            </div>

        <?php elseif ($seccion === 'password'): ?>
            <!-- SECCIÓN CAMBIAR CONTRASEÑA -->
            <h2><i class="bi bi-key"></i> Cambiar Contraseña</h2>
            
            <?php if (isset($_GET['msg'])): ?>
                <div class="alert alert-<?= $_GET['tipo'] ?? 'info' ?> alert-dismissible fade show">
                    <?= htmlspecialchars($_GET['msg']) ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="card p-4">
                <form method="POST" action="accion_perfil.php">
                    <input type="hidden" name="accion" value="cambiar_password">
                    <div class="mb-3">
                        <label class="form-label">Contraseña Actual</label>
                        <input type="password" name="password_actual" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Nueva Contraseña</label>
                        <input type="password" name="password_nueva" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Confirmar Nueva Contraseña</label>
                        <input type="password" name="password_confirmar" class="form-control" required>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-shield-check"></i> Cambiar Contraseña
                    </button>
                </form>
            </div>
        <?php endif; ?>
    </div>

    <footer>
        <div>© <?php echo date("Y"); ?> ZonaStreaming - Panel de APIs - Todos los derechos reservados</div>
        <div class="social-icons">
            <a href="https://www.facebook.com/hugo.roman.71216141/" target="_blank"><i class="bi bi-facebook"></i></a>
            <a href="https://wa.me/593991778665" target="_blank"><i class="bi bi-whatsapp"></i></a>
            <a href="https://tiktok.com" target="_blank"><i class="bi bi-tiktok"></i></a>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.getElementById('theme').addEventListener('change', function(){
            document.body.setAttribute('data-theme', this.value);
            localStorage.setItem('theme', this.value);
        });
        
        const savedTheme = localStorage.getItem('theme') || 'cosmic';
        document.body.setAttribute('data-theme', savedTheme);
        document.getElementById('theme').value = savedTheme;

        function editarStreaming(id, nombre, url, tipo) {
            document.getElementById('edit_streaming_id').value = id;
            document.getElementById('edit_streaming_nombre').value = nombre;
            document.getElementById('edit_streaming_url').value = url;
            document.getElementById('edit_streaming_tipo').value = tipo;
            
            const modal = new bootstrap.Modal(document.getElementById('modalEditarStreaming'));
            modal.show();
        }

        function editarDominio(id, nombre, dominio) {
            document.getElementById('edit_dominio_id').value = id;
            document.getElementById('edit_dominio_nombre').value = nombre;
            document.getElementById('edit_dominio_dominio').value = dominio;
            
            const modal = new bootstrap.Modal(document.getElementById('modalEditarDominio'));
            modal.show();
        }
    </script>
    
    
    <!-- JAVASCRIPT PARA TOKENS Y DESCARGAS -->
            <script>
                let tokenActual = null;
                let plantillaIdActual = null;
                let plantillaNumero = null;
                let tipoDescargaActual = null;

                /**
                 * Obtener token del servidor
                 */
                async function obtenerToken(plantillaId, numero, nombre) {
                    console.log('🔐 Solicitando token para plantilla', plantillaId);
                    
                    try {
                        const response = await fetch(window.location.href + '&api=obtener_token&id=' + plantillaId, {
                            method: 'GET',
                            headers: {
                                'X-Requested-With': 'XMLHttpRequest',
                                'Content-Type': 'application/json'
                            },
                            credentials: 'include'
                        });
                        
                        if (!response.ok) {
                            throw new Error('Error en servidor');
                        }
                        
                        const data = await response.json();
                        
                        if (data.success) {
                            tokenActual = data.token;
                            plantillaIdActual = plantillaId;
                            plantillaNumero = numero;
                            
                            document.getElementById('token-plantilla-numero').textContent = numero;
                            document.getElementById('token-plantilla-nombre').textContent = nombre;
                            document.getElementById('token-valor').value = data.token;
                            document.getElementById('token-ip').textContent = data.ip;
                            
                            console.log('✅ Token obtenido exitosamente');
                            console.log('📍 IP:', data.ip);
                            console.log('⏱️ Válido por:', data.expires_in, 'segundos');
                            
                            const modal = new bootstrap.Modal(document.getElementById('modalObtenerToken'));
                            modal.show();
                        } else {
                            alert('Error: ' + data.error);
                        }
                    } catch (e) {
                        console.error('❌ Error obteniendo token:', e);
                        alert('Error obteniendo token: ' + e.message);
                    }
                }

                /**
                 * Descargar HTML
                 */
                async function descargarHTML() {
                    tipoDescargaActual = 'html';
                    await descargarContenido('html', 'HTML - Plantilla ' + plantillaNumero);
                }

                /**
                 * Descargar CSS
                 */
                async function descargarCSS() {
                    tipoDescargaActual = 'css';
                    await descargarContenido('css', 'CSS - Plantilla ' + plantillaNumero);
                }

                /**
                 * Descargar JavaScript
                 */
                async function descargarJS() {
                    tipoDescargaActual = 'js';
                    await descargarContenido('js', 'JavaScript - Plantilla ' + plantillaNumero);
                }

                /**
                 * Descargar contenido encriptado
                 */
                async function descargarContenido(tipo, titulo) {
                    if (!tokenActual) {
                        alert('No hay token disponible');
                        return;
                    }
                    
                    const logsDiv = document.getElementById('logs-descarga');
                    logsDiv.innerHTML = '';
                    agregarLog('🚀 Iniciando descarga de ' + tipo.toUpperCase() + '...', 'info');
                    
                    // Cerrar modal anterior
                    bootstrap.Modal.getInstance(document.getElementById('modalObtenerToken')).hide();
                    
                    setTimeout(() => {
                        const modalDescarga = new bootstrap.Modal(document.getElementById('modalDescargarContenido'));
                        document.getElementById('titulo-descarga').textContent = titulo;
                        modalDescarga.show();
                        
                        procesarDescarga(tipo);
                    }, 300);
                }

                /**
                 * Procesar descarga
                 */
                async function procesarDescarga(tipo) {
                    const logsDiv = document.getElementById('logs-descarga');
                    
                    try {
                        agregarLog('📥 Descargando ' + tipo.toUpperCase() + ' del servidor...', 'info');
                        
                        const response = await fetch(
                            window.location.href + 
                            '&api=obtener_contenido&id=' + plantillaIdActual + 
                            '&tipo=' + tipo + 
                            '&token=' + tokenActual,
                            {
                                method: 'GET',
                                headers: {
                                    'X-Requested-With': 'XMLHttpRequest',
                                    'Content-Type': 'application/json'
                                },
                                credentials: 'include'
                            }
                        );
                        
                        if (!response.ok) {
                            throw new Error('Error ' + response.status);
                        }
                        
                        const data = await response.json();
                        
                        if (!data.success) {
                            agregarLog('❌ Error: ' + data.error, 'error');
                            return;
                        }
                        
                        agregarLog('✅ Contenido descargado (encriptado)', 'success');
                        agregarLog('🔓 Desencriptando con AES-256-GCM...', 'info');
                        
                        // Mostrar contenido
                        const contenido = data.contenido || 'Contenido vacío';
                        document.getElementById('contenido-descargado').value = contenido;
                        
                        agregarLog('✅ Contenido desencriptado', 'success');
                        agregarLog('🎉 ' + tipo.toUpperCase() + ' cargado exitosamente', 'success');
                        
                    } catch (e) {
                        console.error('❌ Error:', e);
                        agregarLog('❌ Error: ' + e.message, 'error');
                    }
                }

                /**
                 * Agregar log
                 */
                function agregarLog(mensaje, tipo = 'info') {
                    const logsDiv = document.getElementById('logs-descarga');
                    const timestamp = new Date().toLocaleTimeString();
                    const entry = document.createElement('div');
                    entry.textContent = '[' + timestamp + '] ' + mensaje;
                    entry.style.color = {
                        'error': '#ef4444',
                        'success': '#10b981',
                        'warning': '#f59e0b',
                        'info': '#8b5cf6'
                    }[tipo] || '#e4e4e7';
                    entry.style.marginBottom = '5px';
                    logsDiv.appendChild(entry);
                    logsDiv.scrollTop = logsDiv.scrollHeight;
                }

                /**
                 * Copiar al portapapeles
                 */
                function copiarAlPortapapeles(elementId) {
                    const elemento = document.getElementById(elementId);
                    elemento.select();
                    document.execCommand('copy');
                    
                    const btn = event.target.closest('button');
                    const textoOriginal = btn.innerHTML;
                    btn.innerHTML = '<i class="bi bi-check"></i> ¡Copiado!';
                    
                    setTimeout(() => {
                        btn.innerHTML = textoOriginal;
                    }, 2000);
                }

                /**
                 * Descargar como archivo
                 */
                function descargarArchivo() {
                    const contenido = document.getElementById('contenido-descargado').value;
                    const tipo = tipoDescargaActual;
                    
                    const extensiones = {
                        'html': 'html',
                        'css': 'css',
                        'js': 'js'
                    };
                    
                    const nombreArchivo = 'plantilla-' + plantillaNumero + '-' + new Date().getTime() + '.' + extensiones[tipo];
                    
                    const blob = new Blob([contenido], { type: 'text/plain' });
                    const url = URL.createObjectURL(blob);
                    const a = document.createElement('a');
                    a.href = url;
                    a.download = nombreArchivo;
                    document.body.appendChild(a);
                    a.click();
                    document.body.removeChild(a);
                    URL.revokeObjectURL(url);
                    
                    console.log('📥 Descargado:', nombreArchivo);
                }
            </script>
            <!-- SCRIPT PARA ABRIR MODAL DE EDICIÓN -->
            <script>
            function abrirModalEditar(id, nombre, dominio, descripcion) {
                document.getElementById('editar-id').value = id;
                document.getElementById('editar-nombre').value = nombre;
                document.getElementById('editar-dominio').value = dominio;
                document.getElementById('editar-descripcion').value = descripcion;
                
                const modal = new bootstrap.Modal(document.getElementById('modalEditarInfo'));
                modal.show();
            }
            </script>
            
           <!-- SCRIPT PARA ABRIR MODAL DE MOTAS --> 
            
          <script>
        let notasActuales = [];
        let notaActualId = null;
        const modalNota = new bootstrap.Modal(document.getElementById('modalNota'));
        const modalVerNota = new bootstrap.Modal(document.getElementById('modalVerNota'));

        // Cargar notas al iniciar
        document.addEventListener('DOMContentLoaded', function() {
            cargarCategorias();
            cargarNotas();
            
            // Event listeners
            document.getElementById('notaColor').addEventListener('input', function() {
                document.getElementById('colorPreview').style.background = this.value;
            });
            
            document.getElementById('formNota').addEventListener('submit', guardarNota);
        });

        // Cargar categorías
        async function cargarCategorias() {
            try {
                const response = await fetch('accion_notas.php?accion=categorias');
                const data = await response.json();
                
                if (data.success) {
                    const selects = document.querySelectorAll('[id$="Categoria"]');
                    selects.forEach(select => {
                        select.innerHTML = '';
                        data.categorias.forEach(cat => {
                            const option = document.createElement('option');
                            option.value = cat.nombre;
                            option.textContent = cat.nombre;
                            select.appendChild(option);
                        });
                    });
                }
            } catch(e) {
                console.error('Error cargando categorías:', e);
            }
        }

        // Cargar notas
        async function cargarNotas() {
            const categoria = document.getElementById('selectCategoria').value;
            const busqueda = document.getElementById('inputBusqueda').value;
            
            try {
                let url = 'accion_notas.php?accion=obtener';
                if (categoria !== 'todas') url += '&categoria=' + encodeURIComponent(categoria);
                if (busqueda) url += '&busqueda=' + encodeURIComponent(busqueda);
                
                const response = await fetch(url);
                const data = await response.json();
                
                if (data.success) {
                    notasActuales = data.notas;
                    renderizarNotas();
                } else {
                    mostrarError('Error cargando notas');
                }
            } catch(e) {
                console.error('Error:', e);
                mostrarError('Error al cargar notas');
            }
        }

        // Renderizar notas
        function renderizarNotas() {
            const contenedor = document.getElementById('contenedorNotas');
            
            if (notasActuales.length === 0) {
                contenedor.innerHTML = `
                    <div class="text-center text-muted py-5" style="width: 100%;">
                        <i class="bi bi-inbox" style="font-size: 48px; opacity: 0.3;"></i>
                        <p style="margin-top: 15px;">No hay notas que mostrar</p>
                    </div>
                `;
                return;
            }
            
            contenedor.innerHTML = notasActuales.map(nota => `
                <div class="card card-nota" style="border-left-color: ${nota.color}; background: var(--card-bg);" onclick="verNota(${nota.id})">
                    <div class="card-nota-content">
                        <div class="card-nota-titulo" style="color: ${nota.color};">
                            ${escapeHtml(nota.titulo)}
                        </div>
                        <div class="card-nota-texto" style="color: var(--text-color);">
                            ${escapeHtml(nota.contenido)}
                        </div>
                    </div>
                    <div class="card-nota-footer" style="color: var(--text-color); opacity: 0.6; border-top-color: ${nota.color}33;">
                        <span class="badge" style="background-color: ${nota.color};">
                            ${nota.categoria}
                        </span>
                        <span>${formatearFecha(nota.actualizada_en)}</span>
                    </div>
                    <div class="card-nota-acciones">
                        <button type="button" class="btn btn-sm btn-outline-warning" onclick="event.stopPropagation(); editarNota(${nota.id})" title="Editar">
                            <i class="bi bi-pencil"></i> Editar
                        </button>
                        <button type="button" class="btn btn-sm btn-outline-danger" onclick="event.stopPropagation(); eliminarNota(${nota.id})" title="Eliminar">
                            <i class="bi bi-trash"></i> Eliminar
                        </button>
                    </div>
                </div>
            `).join('');
        }

        // Abrir modal nueva nota
        function abrirModalNota() {
            document.getElementById('notaId').value = '';
            document.getElementById('formNota').reset();
            document.getElementById('tituloModal').textContent = 'Nueva Nota';
            document.getElementById('notaTitulo').focus();
            modalNota.show();
        }

        // Editar nota
        function editarNota(id) {
            const nota = notasActuales.find(n => n.id == id);
            if (!nota) return;
            
            document.getElementById('notaId').value = id;
            document.getElementById('notaTitulo').value = nota.titulo;
            document.getElementById('notaCategoria').value = nota.categoria;
            document.getElementById('notaContenido').value = nota.contenido;
            document.getElementById('notaColor').value = nota.color;
            document.getElementById('colorPreview').style.background = nota.color;
            document.getElementById('tituloModal').textContent = 'Editar Nota';
            
            // Scroll al modal
            modalNota.show();
        }

        // Ver nota
        function verNota(id) {
            const nota = notasActuales.find(n => n.id == id);
            if (!nota) return;
            
            notaActualId = id;
            document.getElementById('verNotaTitulo').textContent = nota.titulo;
            document.getElementById('verNotaContenido').textContent = nota.contenido;
            document.getElementById('verNotaBadge').textContent = nota.categoria;
            document.getElementById('verNotaBadge').style.background = nota.color;
            document.getElementById('verNotaFecha').textContent = formatearFecha(nota.actualizada_en);
            document.getElementById('verNotaHeader').style.borderLeft = `4px solid ${nota.color}`;
            modalVerNota.show();
        }

        // Editar nota actual
        function editarNotaActual() {
            modalVerNota.hide();
            editarNota(notaActualId);
        }

        // Eliminar nota actual
        function eliminarNotaActual() {
            if (confirm('¿Estás seguro de que quieres eliminar esta nota?')) {
                window.location.href = 'accion_notas.php?accion=eliminar&id=' + notaActualId;
            }
        }

        // Guardar nota
        async function guardarNota(e) {
            e.preventDefault();
            
            const id = document.getElementById('notaId').value;
            const accion = id ? 'actualizar' : 'crear';
            
            const formData = new FormData();
            formData.append('accion', accion);
            formData.append('id', id);
            formData.append('titulo', document.getElementById('notaTitulo').value);
            formData.append('contenido', document.getElementById('notaContenido').value);
            formData.append('categoria', document.getElementById('notaCategoria').value);
            formData.append('color', document.getElementById('notaColor').value);
            
            try {
                const response = await fetch('accion_notas.php', {
                    method: 'POST',
                    body: formData
                });
                
                const data = await response.json();
                
                if (data.success) {
                    // Si es una nota nueva, agregarla al inicio del array
                    if (!id) {
                        const nuevaNota = {
                            id: data.id,
                            titulo: document.getElementById('notaTitulo').value,
                            contenido: document.getElementById('notaContenido').value,
                            categoria: document.getElementById('notaCategoria').value,
                            color: document.getElementById('notaColor').value,
                            actualizada_en: new Date().toISOString()
                        };
                        notasActuales.unshift(nuevaNota);
                    } else {
                        // Si es una actualización, actualizar en el array sin recargar desde BD
                        const notaEditada = notasActuales.find(n => n.id == id);
                        if (notaEditada) {
                            notaEditada.titulo = document.getElementById('notaTitulo').value;
                            notaEditada.contenido = document.getElementById('notaContenido').value;
                            notaEditada.categoria = document.getElementById('notaCategoria').value;
                            notaEditada.color = document.getElementById('notaColor').value;
                            notaEditada.actualizada_en = new Date().toISOString();
                        }
                    }
                    
                    renderizarNotas();
                    modalNota.hide();
                } else {
                    alert('Error: ' + data.error);
                }
            } catch(e) {
                console.error('Error:', e);
                alert('Error al guardar');
            }
        }

        // Eliminar nota
        async function eliminarNota(id) {
            if (!confirm('¿Estás seguro?')) return;
            
            try {
                const response = await fetch('accion_notas.php?accion=eliminar&id=' + id);
                
                // Eliminar del array sin recargar
                notasActuales = notasActuales.filter(n => n.id != id);
                renderizarNotas();
                
            } catch(e) {
                console.error('Error:', e);
                alert('Error al eliminar');
            }
        }

        // Buscar notas
        function buscarNotas() {
            cargarNotas();
        }

        // Utilidades
        function formatearFecha(fecha) {
            const date = new Date(fecha);
            return date.toLocaleDateString('es-ES') + ' ' + date.toLocaleTimeString('es-ES', {hour: '2-digit', minute: '2-digit'});
        }

        function escapeHtml(text) {
            const map = {
                '&': '&amp;',
                '<': '&lt;',
                '>': '&gt;',
                '"': '&quot;',
                "'": '&#039;'
            };
            return text.replace(/[&<>"']/g, m => map[m]);
        }

        function mostrarError(msg) {
            console.error(msg);
        }
    </script>

    
</body>
</html>

