<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

// Si ya está logueado, redirigir al panel
if (!empty($_SESSION['logueado'])) {
    header("Location: index.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    require 'db.php';
    
    $usuario = $_POST['usuario'] ?? '';
    $clave = $_POST['clave'] ?? '';
    
    if (!empty($usuario) && !empty($clave)) {
        // Consulta en la base de datos
        $stmt = $pdo->prepare("SELECT id, usuario, password FROM usuarios WHERE usuario = ?");
        $stmt->execute([$usuario]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($row && password_verify($clave, $row['password'])) {
            // Login exitoso
            $_SESSION['logueado'] = true;
            $_SESSION['user_id'] = $row['id'];
            $_SESSION['usuario'] = $row['usuario'];
            
            // Actualizar último acceso
            $stmt = $pdo->prepare("UPDATE usuarios SET ultimo_acceso = NOW() WHERE id = ?");
            $stmt->execute([$row['id']]);
            
            header("Location: index.php");
            exit;
        } else {
            $error = "Usuario o contraseña incorrectos";
        }
    } else {
        $error = "Por favor complete todos los campos";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Login - Streaming Pro</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    <style>
        body {        
            background: url('assets/background.png') no-repeat center center fixed;
            background-size: cover;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-family: Arial, sans-serif;
        }
        .login-container {
            background: #1e1e1e;
            padding: 2rem;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.7);
            width: 100%;
            max-width: 400px;
        }
        .login-container h3 {
            text-align: center;
            margin-bottom: 1rem;
            color: #fff;
        }
        .form-control {
            background-color: #2c2c2c;
            border: none;
            color: white;
        }
        .form-control:focus {
            background-color: #333;
            color: white;
            box-shadow: none;
        }
        .btn-custom {
            background-color: #007bff;
            border: none;
            font-weight: bold;
        }
        .btn-custom:hover {
            background-color: #0056b3;
        }
        .error-message {
            background: rgba(255, 0, 0, 0.2);
            padding: 0.5rem;
            border-radius: 5px;
            color: #ff4d4d;
            text-align: center;
            margin-bottom: 1rem;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h3>Bienvenido!<br><small>ZonaStreaming PANEL DE APIS</small></h3>
        <?php if (!empty($error)): ?>
            <div class="error-message"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        <form method="POST">
            <div class="mb-3">
                <label>Correo Electrónico</label>
                <input type="text" name="usuario" class="form-control" placeholder="nombre@ejemplo.com" required>
            </div>
            <div class="mb-3">
                <label>Contraseña</label>
                <input type="password" name="clave" class="form-control" placeholder="Introduce tu contraseña" required>
            </div>
            <div class="form-check mb-3">
                <input type="checkbox" class="form-check-input" id="remember">
                <label class="form-check-label" for="remember">Recuérdame</label>
            </div>
            <button class="btn btn-custom w-100">Iniciar Sesión</button>
        </form>
    </div>
</body>
</html>