<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// deezer, itunes, spotify or azuracast./
$ApiType = "deezer";

//// Valores por defecto.
$defaultArtist = "No Disponible";
$defaultTitle = "Artista";
$defaultArtwork = "https://radiozonamusic.com/wp-content/uploads/2025/08/bg_album_art.png";



// Lista de anuncios personalizados con sus respectivas imágenes/
$ads = [
    "CONTACTENOS: +593991778665" => [
        "artist" => "URL BLOQUEADA",
        "artwork" => "https://zonaradio.net/bloqueada.png"
    
    ]
];



//Input data query.
$GetDataInput = filter_input(INPUT_GET, 'query');

//Remove Any Filename if it ends with any audio mime type
$FilterReplace = str_replace(array('.mp3', '.aac', '.wav'), '', $GetDataInput);

// Función para verificar si coincide con un anuncio publicitario
function checkForAd($query, $ads)
{
    foreach ($ads as $songTitle => $adData) {
        // Compara ignorando mayúsculas/minúsculas y espacios extra
        if (stripos($query, $songTitle) !== false && stripos($query, $adData['artist']) !== false) {
            return json_encode(array(
                'results' => array(
                    'artist' => $adData['artist'],
                    'title' => $songTitle,
                    'artwork' => $adData['artwork']
                )
            ));
        }
    }

    return null; // No se encontró un anuncio
}

// Comprueba si la entrada es un anuncio publicitario
$adResponse = checkForAd($FilterReplace, $ads);
if ($adResponse) {
    echo $adResponse;
    exit; // Si es un anuncio, termina aquí
}


function getAzuracast($defaultArtist, $defaultTitle, $defaultArtwork)
{
    $API_URL = ''; // URL de la API de AzuraCast.
    $FCG = @json_decode(file_get_contents($API_URL));
    $artist = $FCG->now_playing->song->artist ?? $defaultArtist;
    $track = $FCG->now_playing->song->title ?? $defaultTitle;
    $artwork = $FCG->now_playing->song->art ?? $defaultArtwork;

    return json_encode(array(
        'results' => array(
            'artist' => $artist,
            'title' => $track,
            'artwork' => $artwork
        )
    ));
}

// Spotify API Function
function getSpotify($SpotifyInputData)
{
    // put spotify Client_ID:CLIENT_TOKEN Where you see it :)
    //$b64 = base64_encode('e31280605c6e44a3a14a532b65987e0a:fe79e7eda196457cb71b71f92bf42ed1');
    $b64 = base64_encode('8bcd2be297614799b5aa7013021f3dea:54103daa251b47b0adc8e782fcdae42a');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://accounts.spotify.com/api/token');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
    $headers = array();
    $headers[] = "Authorization: Basic $b64";
    $headers[] = 'Content-Type: application/x-www-form-urlencoded';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $result = curl_exec($ch);
    $JSP = json_decode($result);
    $Acesstoken = $JSP->access_token;
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, 'https://api.spotify.com/v1/search?q=' . urlencode($SpotifyInputData) . '&type=track&limit=1');
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
    $headers = array();
    $headers[] = 'Accept: application/json';
    $headers[] = 'Content-Type: application/json';
    $headers[] = "Authorization: Bearer $Acesstoken";
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    $spotresult = curl_exec($curl);
    $JSD = json_decode($spotresult);
    $Artwork = $JSD->tracks->items[0]->album->images[0]->url;
    $Album = $JSD->tracks->items[0]->album->name;
    $Artist = $JSD->tracks->items[0]->artists[0]->name;
    $TrackName = $JSD->tracks->items[0]->name;
    $Duration = $JSD->tracks->items[0]->duration_ms;
    $Stream = $JSD->tracks->items[0]->external_urls->spotify;

    $JsonArray['results'] = array(
        'artist' => $Artist,
        'title' => $TrackName,
        'artwork' => $Artwork,
        'album' => $Album,
        'duration_ms' => $Duration,
        'stream' => $Stream
    );
    curl_close($curl);

    return (json_encode($JsonArray));

}

function getDeezer($DataInputDeezer, $defaultArtist, $defaultTitle, $defaultArtwork)
{
    $url = 'https://api.deezer.com/search?q=' . urlencode($DataInputDeezer);
    $FGC = @file_get_contents($url);
    $JSD = json_decode($FGC);

    $artist = $JSD->data[0]->artist->name ?? $defaultArtist;
    $title = $JSD->data[0]->title ?? $defaultTitle;
    $artwork = $JSD->data[0]->album->cover_xl ?? $defaultArtwork;
    $stream = $JSD->data[0]->link ?? null; // Enlace a la canción en Deezer

    return json_encode(array(
        'results' => array(
            'artist' => $artist,
            'title' => $title,
            'artwork' => $artwork,
            'stream' => $stream // Agregamos el enlace al stream
        )
    ));
}




function getiTunes($DataInputItunes, $defaultArtist, $defaultTitle, $defaultArtwork)
{
    $url = 'https://itunes.apple.com/search?term=' . urlencode($DataInputItunes) . '&media=music&limit=1';
    $FGC = @file_get_contents($url);
    $JSD = json_decode($FGC);
    $artist = $JSD->results[0]->artistName ?? $defaultArtist;
    $title = $JSD->results[0]->trackCensoredName ?? $defaultTitle;
    $artwork = $JSD->results[0]->artworkUrl100 ?? $defaultArtwork;

    return json_encode(array(
        'results' => array(
            'artist' => $artist,
            'title' => $title,
            'artwork' => $artwork
        )
    ));
}

// Manejo de entrada y API.
if (empty($GetDataInput)) {
    echo json_encode(array(
        'results' => array(
            'artist' => $defaultArtist,
            'title' => $defaultTitle,
            'artwork' => $defaultArtwork
        )
    ));
} elseif ($ApiType === "deezer") {
    echo getDeezer($FilterReplace, $defaultArtist, $defaultTitle, $defaultArtwork);
} elseif ($ApiType === "itunes") {
    echo getiTunes($FilterReplace, $defaultArtist, $defaultTitle, $defaultArtwork);
} elseif ($ApiType === "spotify") {
    echo getSpotify($FilterReplace, $defaultArtist, $defaultTitle, $defaultArtwork);
} elseif ($ApiType === "azuracast") {
    echo getAzuracast($defaultArtist, $defaultTitle, $defaultArtwork);
}
