<?php
require 'db.php'; // conexión a MySQL

// Consulta única para obtener dominios por tipo
$stmt = $pdo->query("SELECT dominio, tipo FROM dominios WHERE estado='activo'");
$dominios = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Separar listas según tipo
$allowed_origins = [];
$allowed_domains = [];

foreach ($dominios as $d) {
    if ($d['tipo'] === 'origen') {
        $allowed_origins[] = strtolower($d['dominio']);
    } elseif ($d['tipo'] === 'validacion') {
        $allowed_domains[] = strtolower($d['dominio']);
    }
}

// Obtener origen del navegador
$origin = $_SERVER['HTTP_ORIGIN'] ?? '';
$origin_host = parse_url($origin, PHP_URL_HOST);

// Función para validar con subdominios
function dominioPermitido($host, $lista) {
    $host = strtolower($host);
    foreach ($lista as $permitido) {
        if ($host === $permitido || preg_match('/(\.|^)'.preg_quote($permitido).'$/', $host)) {
            return true;
        }
    }
    return false;
}

// Si el origen está permitido, habilitar CORS
if ($origin_host && dominioPermitido($origin_host, $allowed_origins)) {
    header("Access-Control-Allow-Origin: $origin");
    header("Access-Control-Allow-Credentials: true");
}

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

// Preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Validar dominio enviado
if (!isset($_GET['dominio']) || empty($_GET['dominio'])) {
    echo json_encode(["error" => "No se especificó el dominio"]);
    exit;
}

$dominio = $_GET['dominio'];
$host = parse_url("https://$dominio", PHP_URL_HOST);

// Validar si el dominio está en lista de validación
if (dominioPermitido($host, $allowed_domains)) {
    echo json_encode([
        "dominio" => $dominio,
        "valido" => true
    ]);
} else {
    echo json_encode([
        "dominio" => $dominio,
        "valido" => false
    ]);
}
?>
