<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Configuración
$config = [
    'api_type' => 'auto', // auto, deezer, itunes, spotify, youtube, azuracast
    'fallback_enabled' => true,
    'cache_enabled' => true,
    'cache_duration' => 3600, // 1 hora
    'timeout' => 10,
    'spotify_client_id' => '8bcd2be297614799b5aa7013021f3dea',
    'spotify_client_secret' => '54103daa251b47b0adc8e782fcdae42a',
    'youtube_api_key' => 'AIzaSyCinQkDEATnpeZr8lFW24ywyFH0CvL4Bhk',
    'include_youtube_video' => true, // Nueva opción para incluir videos
];

// Valores por defecto
$defaults = [
    'artist' => 'No Disponible',
    'title' => 'Artista',
    'artwork' => 'https://zonaradio.net/bloqueada.png',
    'album' => 'Desconocido',
    'year' => 'Desconocido',
    'genre' => 'Desconocido',
    'stream' => null,
    'youtube' => null
];

// Lista de anuncios personalizados
$ads = [
    "CONTACTENOS: +593991778665" => [
        "artist" => "URL BLOQUEADA",
        "artwork" => "https://zonaradio.net/bloqueada.png"
    ]
];

// Obtener y limpiar entrada
$GetDataInput = filter_input(INPUT_GET, 'query', FILTER_SANITIZE_STRING);
$ApiTypeOverride = filter_input(INPUT_GET, 'source', FILTER_SANITIZE_STRING);

if ($ApiTypeOverride && in_array($ApiTypeOverride, ['deezer', 'itunes', 'spotify', 'youtube', 'auto'])) {
    $config['api_type'] = $ApiTypeOverride;
}

$FilterReplace = str_replace(['.mp3', '.aac', '.wav', '.flac', '.ogg', '.m4a'], '', $GetDataInput);

// Sistema de caché simple
class SimpleCache {
    private $cacheDir = 'cache/';
    
    public function __construct() {
        if (!file_exists($this->cacheDir)) {
            @mkdir($this->cacheDir, 0755, true);
        }
    }
    
    public function get($key) {
        $file = $this->cacheDir . md5($key) . '.cache';
        if (file_exists($file)) {
            $data = json_decode(file_get_contents($file), true);
            if ($data && $data['expires'] > time()) {
                return $data['content'];
            }
            @unlink($file);
        }
        return null;
    }
    
    public function set($key, $content, $duration) {
        $file = $this->cacheDir . md5($key) . '.cache';
        $data = [
            'expires' => time() + $duration,
            'content' => $content
        ];
        @file_put_contents($file, json_encode($data));
    }
}

$cache = new SimpleCache();

// Función para hacer peticiones HTTP
function makeRequest($url, $headers = [], $timeout = 10) {
    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        if (!empty($headers)) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }
        
        $result = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode >= 200 && $httpCode < 300 && $result) {
            return $result;
        }
    }
    
    $context = stream_context_create([
        'http' => [
            'timeout' => $timeout,
            'header' => implode("\r\n", $headers)
        ]
    ]);
    
    $result = @file_get_contents($url, false, $context);
    return $result ?: false;
}

function getYoutubeVideoId($artist, $title, $apiKey, $timeout) {
    error_log("YouTube API Key: " . substr($apiKey, 0, 10) . "...");
    error_log("Buscando: " . $artist . " - " . $title);
    
    if (empty($apiKey) || $apiKey === 'AIzaSyCinQkDEATnpeZr8lFW24ywyFH0CvL4Bhk') {
        error_log("API Key inválida o vacía");
        return null;
    }
    
    try {
        $query = trim($artist . ' ' . $title . ' official');
        $url = 'https://www.googleapis.com/youtube/v3/search?part=snippet&q=' . 
               urlencode($query) . 
               '&type=video&videoCategoryId=10&maxResults=1&key=' . $apiKey;
        
        error_log("URL de búsqueda: " . $url);
        
        $response = makeRequest($url, [], $timeout);
        
        error_log("Respuesta YouTube: " . substr($response, 0, 100));
        
        if (!$response) return null;
        
        $data = json_decode($response, true);
        $videoId = $data['items'][0]['id']['videoId'] ?? null;
        
        error_log("Video ID encontrado: " . ($videoId ?? 'null'));
        
        return $videoId;
    } catch (Exception $e) {
        error_log("YouTube API Error: " . $e->getMessage());
        return null;
    }
}

// Función para verificar anuncios
function checkForAd($query, $ads) {
    foreach ($ads as $songTitle => $adData) {
        if (stripos($query, $songTitle) !== false && stripos($query, $adData['artist']) !== false) {
            return [
                'artist' => $adData['artist'],
                'title' => $songTitle,
                'artwork' => $adData['artwork'],
                'source' => 'ad',
                'youtube' => null
            ];
        }
    }
    return null;
}

// API: Deezer
function getDeezer($query, $defaults, $timeout, $config) {
    try {
        $url = 'https://api.deezer.com/search?q=' . urlencode($query) . '&limit=5';
        $response = makeRequest($url, [], $timeout);
        
        if (!$response) return null;
        
        $data = json_decode($response, true);
        
        if (empty($data['data'])) return null;
        
        // Buscar la mejor coincidencia
        $bestMatch = null;
        $queryLower = strtolower($query);
        $maxScore = 0;
        
        foreach ($data['data'] as $track) {
            $trackTitle = strtolower($track['title'] ?? '');
            $trackArtist = strtolower($track['artist']['name'] ?? '');
            $combined = $trackArtist . ' ' . $trackTitle;
            
            $score = 0;
            
            if ($trackTitle === $queryLower) {
                $score += 100;
            } elseif (strpos($queryLower, $trackTitle) !== false || strpos($trackTitle, $queryLower) !== false) {
                $score += 50;
            }
            
            if (strpos($combined, $queryLower) !== false || strpos($queryLower, $combined) !== false) {
                $score += 30;
            }
            
            if (isset($track['rank'])) {
                $score += min($track['rank'] / 10000, 20);
            }
            
            if ($score > $maxScore) {
                $maxScore = $score;
                $bestMatch = $track;
            }
        }
        
        if (!$bestMatch) {
            $bestMatch = $data['data'][0];
        }
        
        $track = $bestMatch;
        
        $result = [
            'artist' => $track['artist']['name'] ?? $defaults['artist'],
            'title' => $track['title'] ?? $defaults['title'],
            'artwork' => [
                'small' => $track['album']['cover_small'] ?? $defaults['artwork'],
                'medium' => $track['album']['cover_medium'] ?? $defaults['artwork'],
                'large' => $track['album']['cover_big'] ?? $defaults['artwork'],
                'xl' => $track['album']['cover_xl'] ?? $defaults['artwork']
            ],
            'stream' => $track['link'] ?? null,
            'album' => $track['album']['title'] ?? $defaults['album'],
            'year' => $defaults['year'],
            'genre' => $defaults['genre'],
            'source' => 'deezer',
            'duration' => isset($track['duration']) ? gmdate("i:s", $track['duration']) : null,
            'preview' => $track['preview'] ?? null,
            'rank' => $track['rank'] ?? null,
            'youtube' => null
        ];
        
        // Obtener detalles del álbum
        if (!empty($track['album']['id'])) {
            $albumUrl = 'https://api.deezer.com/album/' . $track['album']['id'];
            $albumResponse = makeRequest($albumUrl, [], $timeout);
            
            if ($albumResponse) {
                $albumData = json_decode($albumResponse, true);
                
                if (!empty($albumData['release_date'])) {
                    $result['year'] = substr($albumData['release_date'], 0, 4);
                }
                
                if (!empty($albumData['genres']['data'])) {
                    $genres = array_column($albumData['genres']['data'], 'name');
                    $result['genre'] = implode(', ', $genres);
                }
                
                if (!empty($albumData['label'])) {
                    $result['label'] = $albumData['label'];
                }
            }
        }
        
        // Obtener información del artista
        if (!empty($track['artist']['id'])) {
            $artistUrl = 'https://api.deezer.com/artist/' . $track['artist']['id'];
            $artistResponse = makeRequest($artistUrl, [], $timeout);
            
            if ($artistResponse) {
                $artistData = json_decode($artistResponse, true);
                
                if (!empty($artistData['picture_xl'])) {
                    $result['artist_picture'] = $artistData['picture_xl'];
                }
                
                if ($result['genre'] === $defaults['genre'] && !empty($artistData['id'])) {
                    $artistTopUrl = 'https://api.deezer.com/artist/' . $artistData['id'] . '/top?limit=1';
                    $topResponse = makeRequest($artistTopUrl, [], $timeout);
                    
                    if ($topResponse) {
                        $topData = json_decode($topResponse, true);
                        if (!empty($topData['data'][0]['album']['id'])) {
                            $topAlbumUrl = 'https://api.deezer.com/album/' . $topData['data'][0]['album']['id'];
                            $topAlbumResponse = makeRequest($topAlbumUrl, [], $timeout);
                            
                            if ($topAlbumResponse) {
                                $topAlbumData = json_decode($topAlbumResponse, true);
                                if (!empty($topAlbumData['genres']['data'])) {
                                    $genres = array_column($topAlbumData['genres']['data'], 'name');
                                    $result['genre'] = implode(', ', $genres);
                                }
                            }
                        }
                    }
                }
            }
        }
        
        // Buscar video de YouTube
        if ($config['include_youtube_video']) {
            $result['youtube'] = getYoutubeVideoId(
                $result['artist'], 
                $result['title'], 
                $config['youtube_api_key'], 
                $timeout
            );
        }
        
        return $result;
    } catch (Exception $e) {
        error_log("Deezer API Error: " . $e->getMessage());
        return null;
    }
}

// API: iTunes
function getItunes($query, $defaults, $timeout, $config) {
    try {
        $url = 'https://itunes.apple.com/search?term=' . urlencode($query) . '&media=music&limit=1&entity=song';
        $response = makeRequest($url, [], $timeout);
        
        if (!$response) return null;
        
        $data = json_decode($response, true);
        
        if (empty($data['results'][0])) return null;
        
        $track = $data['results'][0];
        
        $artwork = isset($track['artworkUrl100']) ? str_replace('100x100', '600x600', $track['artworkUrl100']) : $defaults['artwork'];
        
        $result = [
            'artist' => $track['artistName'] ?? $defaults['artist'],
            'title' => $track['trackName'] ?? $defaults['title'],
            'artwork' => [
                'small' => $artwork,
                'medium' => $artwork,
                'large' => $artwork,
                'xl' => $artwork
            ],
            'stream' => $track['trackViewUrl'] ?? null,
            'album' => $track['collectionName'] ?? $defaults['album'],
            'year' => isset($track['releaseDate']) ? substr($track['releaseDate'], 0, 4) : $defaults['year'],
            'genre' => $track['primaryGenreName'] ?? $defaults['genre'],
            'source' => 'itunes',
            'youtube' => null
        ];
        
        // Buscar video de YouTube
        if ($config['include_youtube_video']) {
            $result['youtube'] = getYoutubeVideoId(
                $result['artist'], 
                $result['title'], 
                $config['youtube_api_key'], 
                $timeout
            );
        }
        
        return $result;
    } catch (Exception $e) {
        return null;
    }
}

// API: Spotify
function getSpotify($query, $defaults, $clientId, $clientSecret, $timeout, $cache, $config) {
    try {
        $token = $cache->get('spotify_token');
        
        if (!$token) {
            $tokenUrl = 'https://accounts.spotify.com/api/token';
            $headers = [
                'Authorization: Basic ' . base64_encode($clientId . ':' . $clientSecret),
                'Content-Type: application/x-www-form-urlencoded'
            ];
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $tokenUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, 'grant_type=client_credentials');
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
            
            $tokenResponse = curl_exec($ch);
            curl_close($ch);
            
            if (!$tokenResponse) return null;
            
            $tokenData = json_decode($tokenResponse, true);
            
            if (empty($tokenData['access_token'])) return null;
            
            $token = $tokenData['access_token'];
            $cache->set('spotify_token', $token, 3500);
        }
        
        $searchUrl = 'https://api.spotify.com/v1/search?q=' . urlencode($query) . '&type=track&limit=1';
        $response = makeRequest($searchUrl, ['Authorization: Bearer ' . $token], $timeout);
        
        if (!$response) return null;
        
        $data = json_decode($response, true);
        
        if (empty($data['tracks']['items'][0])) return null;
        
        $track = $data['tracks']['items'][0];
        
        $artwork = $defaults['artwork'];
        if (!empty($track['album']['images'])) {
            $artwork = $track['album']['images'][0]['url'] ?? $defaults['artwork'];
        }
        
        $result = [
            'artist' => $track['artists'][0]['name'] ?? $defaults['artist'],
            'title' => $track['name'] ?? $defaults['title'],
            'artwork' => [
                'small' => $artwork,
                'medium' => $artwork,
                'large' => $artwork,
                'xl' => $artwork
            ],
            'stream' => $track['external_urls']['spotify'] ?? null,
            'album' => $track['album']['name'] ?? $defaults['album'],
            'year' => isset($track['album']['release_date']) ? substr($track['album']['release_date'], 0, 4) : $defaults['year'],
            'genre' => $defaults['genre'],
            'source' => 'spotify',
            'preview_url' => $track['preview_url'] ?? null,
            'youtube' => null
        ];
        
        // Buscar video de YouTube
        if ($config['include_youtube_video']) {
            $result['youtube'] = getYoutubeVideoId(
                $result['artist'], 
                $result['title'], 
                $config['youtube_api_key'], 
                $timeout
            );
        }
        
        return $result;
    } catch (Exception $e) {
        return null;
    }
}

// API: YouTube
function getYoutube($query, $defaults, $apiKey, $timeout) {
    try {
        $url = 'https://www.googleapis.com/youtube/v3/search?part=snippet&q=' . urlencode($query . ' official audio') . '&type=video&videoCategoryId=10&maxResults=1&key=' . $apiKey;
        $response = makeRequest($url, [], $timeout);
        
        if (!$response) return null;
        
        $data = json_decode($response, true);
        
        if (empty($data['items'][0])) return null;
        
        $video = $data['items'][0];
        $videoId = $video['id']['videoId'] ?? null;
        $fullTitle = $video['snippet']['title'] ?? $defaults['title'];
        $channelTitle = $video['snippet']['channelTitle'] ?? $defaults['artist'];
        
        $artist = $channelTitle;
        $title = $fullTitle;
        
        if (preg_match('/^(.+?)\s*[-:]\s*(.+)$/', $fullTitle, $matches)) {
            $artist = trim($matches[1]);
            $title = trim($matches[2]);
        } elseif (preg_match('/^(.+?)\s*\((.+?)\)$/', $fullTitle, $matches)) {
            $title = trim($matches[1]);
            $possibleArtist = trim($matches[2]);
            if (strlen($possibleArtist) < 50) {
                $artist = $possibleArtist;
            }
        }
        
        $title = preg_replace('/\s*\((Official|Lyrics?|Audio|Video|Music Video|HD)\)/i', '', $title);
        $title = preg_replace('/\s*\[(Official|Lyrics?|Audio|Video|Music Video|HD)\]/i', '', $title);
        
        $artwork = $defaults['artwork'];
        if (!empty($video['snippet']['thumbnails']['high']['url'])) {
            $artwork = $video['snippet']['thumbnails']['high']['url'];
        } elseif (!empty($video['snippet']['thumbnails']['medium']['url'])) {
            $artwork = $video['snippet']['thumbnails']['medium']['url'];
        }
        
        return [
            'artist' => $artist,
            'title' => $title,
            'artwork' => [
                'small' => $artwork,
                'medium' => $artwork,
                'large' => $artwork,
                'xl' => $artwork
            ],
            'stream' => $videoId ? 'https://www.youtube.com/watch?v=' . $videoId : null,
            'album' => 'YouTube',
            'year' => $defaults['year'],
            'genre' => $defaults['genre'],
            'source' => 'youtube',
            'youtube' => $videoId
        ];
    } catch (Exception $e) {
        return null;
    }
}

// Función principal con fallback
function searchMusic($query, $config, $defaults, $cache) {
    if ($config['cache_enabled']) {
        $cacheKey = 'music_' . $config['api_type'] . '_' . $query;
        $cached = $cache->get($cacheKey);
        if ($cached) {
            return $cached;
        }
    }
    
    $sources = ['deezer', 'itunes', 'spotify', 'youtube'];
    
    if ($config['api_type'] === 'auto') {
        $tryOrder = $sources;
    } else {
        $tryOrder = [$config['api_type']];
        if ($config['fallback_enabled']) {
            $tryOrder = array_merge($tryOrder, array_diff($sources, [$config['api_type']]));
        }
    }
    
    $result = null;
    
    foreach ($tryOrder as $source) {
        switch ($source) {
            case 'deezer':
                $result = getDeezer($query, $defaults, $config['timeout'], $config);
                break;
            case 'itunes':
                $result = getItunes($query, $defaults, $config['timeout'], $config);
                break;
            case 'spotify':
                if ($config['spotify_client_id'] !== '8bcd2be297614799b5aa7013021f3dea') {
                    $result = getSpotify($query, $defaults, $config['spotify_client_id'], 
                                       $config['spotify_client_secret'], $config['timeout'], $cache, $config);
                }
                break;
            case 'youtube':
                if ($config['youtube_api_key'] !== 'AIzaSyC2p-VL30O962Z5xlvGX9R8Bd4aiN3NPG4') {
                    $result = getYoutube($query, $defaults, $config['youtube_api_key'], $config['timeout']);
                }
                break;
        }
        
        if ($result) {
            if ($config['cache_enabled']) {
                $cache->set($cacheKey, $result, $config['cache_duration']);
            }
            return $result;
        }
    }
    
    return array_merge($defaults, ['source' => 'none']);
}

// Procesar solicitud
try {
    if (empty($GetDataInput)) {
        $response = array_merge($defaults, ['source' => 'default']);
    } else {
        $adResult = checkForAd($FilterReplace, $ads);
        if ($adResult) {
            $response = $adResult;
        } else {
            $response = searchMusic($FilterReplace, $config, $defaults, $cache);
        }
    }
    
    echo json_encode(['results' => $response], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => 'Error interno del servidor',
        'results' => array_merge($defaults, ['source' => 'error'])
    ]);
}
?>