const form = document.getElementById('configForm')
const generateCodeBtn = document.getElementById('generateCode')
const resultContainer = document.getElementById('resultContainer')
const copyCodeBtn = document.getElementById('copyCode')

const COPY_TEXT = copyCodeBtn.innerText
const COPIED_TEXT = 'COPIADO!'
const STORAGE_KEY = 'configFormData'

function initializeForm () {
  if (!form) return

  // Restaurar valores desde localStorage
  const savedData = localStorage.getItem(STORAGE_KEY)
  if (savedData) {
    try {
      const data = JSON.parse(savedData)
      for (const [key, value] of Object.entries(data)) {
        const field = form.elements[key]
        if (field) field.value = value
      }
    } catch (err) {
      console.error('Error restaurando datos:', err)
    }
  }

  // Guardar valores en localStorage en cada cambio
  form.addEventListener('input', () => {
    const formData = new FormData(form)
    const data = Object.fromEntries(formData.entries())
    localStorage.setItem(STORAGE_KEY, JSON.stringify(data))
  })

  // Quitar clase "is-required" cuando el campo se corrige
  form.querySelectorAll('input, select, textarea').forEach(field => {
    field.addEventListener('input', () => {
      if (field.checkValidity()) {
        field.classList.remove('is-required')
      }
    })
  })

  form.onsubmit = function (e) {
    e.preventDefault()
    return false
  }

  function generatePlayerCode (e) {
    e.preventDefault()

    let valid = true
    form.querySelectorAll('input[required], select[required], textarea[required]').forEach(field => {
      if (!field.checkValidity()) {
        field.classList.add('is-required')
        valid = false
      }
    })

    if (!valid) return

    const formData = new FormData(form)
    const data = Object.fromEntries(formData.entries())
    const jsonData = btoa(JSON.stringify(data))
    const playerUrl = `${window.location.origin}${window.location.pathname}player.php?data=${jsonData}`

    resultContainer.value = playerUrl
  }

  generateCodeBtn.addEventListener('click', generatePlayerCode)
}

function initCopyToClipboard () {
  function copyToClipboard () {
    if (!resultContainer.value) return
    navigator.clipboard.writeText(resultContainer.value)
      .then(() => {
        copyCodeBtn.disabled = true
        copyCodeBtn.innerText = COPIED_TEXT
        copyCodeBtn.classList.add('copied')
        setTimeout(() => {
          copyCodeBtn.disabled = false
          copyCodeBtn.innerText = COPY_TEXT
          copyCodeBtn.classList.remove('copied')
        }, 2000)
      })
  }

  copyCodeBtn.addEventListener('click', copyToClipboard)
}

initializeForm()
initCopyToClipboard()