<?php
error_reporting(0);

// Obtener y decodificar datos
$data = isset($_GET['data']) ? $_GET['data'] : '';
if (empty($data)) {
    die('Error: No se proporcionaron datos de configuración');
}

$config = json_decode(base64_decode($data), true);
if (!$config) {
    die('Error: Datos de configuración inválidos');
}

// Extraer configuración
$radioId = $config['id'] ?? '1';
$panel = $config['panel'] ?? 'mwebzonaradio.com';
$primaryColor = $config['primary'] ?? '#d60505';
$coverServer = $config['server'] ?? 'itunes';
$port = $config['port'] ?? '8000';
$streamServer = $config['stream'] ?? 'sonicpanel.zonaradio.net';
$theme = $config['theme'] ?? 'nexo-float';

// Mapeo de temas a archivos CSS
$themeFiles = [
    'nexo-bar' => 'nexo-bar.css',
    'nexo-banner' => 'nexo-banner.css',
    'nexo-float' => 'nexo-float.css',
    'nexo-grid' => 'nexo-grid.css'
];

$cssFile = $themeFiles[$theme] ?? 'nexo-float.css';

// Funcin para generar el modal de programacin
function getProgramModal() {
  return '
<div class="program-modal" id="program-modal">
  <div class="program-header">
    <h2 class="program-title">Programacin</h2>
    <button class="program-close" id="program-close" aria-label="Close" data-close>
      <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24">
        <path d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10-4.477 10-10 10Zm0-2a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm0-9.414 2.828-2.829 1.415 1.415L13.414 12l2.829 2.828-1.415 1.415L12 13.414l-2.828 2.829-1.415-1.415L10.586 12 7.757 9.172l1.415-1.415L12 10.586Z"/>
      </svg>
    </button>
  </div>
  <div class="program-wrapper schedule">
    <div class="program-super" id="program-super">
      <div class="program-tabs">
        <button class="program-button" data-tab="program-monday">LUN</button>
        <button class="program-button" data-tab="program-tuesday">MAR</button>
        <button class="program-button" data-tab="program-wednesday">MI07</button>
        <button class="program-button" data-tab="program-thursday">JUE</button>
        <button class="program-button" data-tab="program-friday">VIE</button>
        <button class="program-button" data-tab="program-saturday">SAB</button>
        <button class="program-button" data-tab="program-sunday">DOM</button>
      </div>
      <div class="programs-list scrollbar" id="programs-list">
        <ul class="schedule-list" id="program-monday"></ul>
        <ul class="schedule-list" id="program-tuesday"></ul>
        <ul class="schedule-list" id="program-wednesday"></ul>
        <ul class="schedule-list" id="program-thursday"></ul>
        <ul class="schedule-list" id="program-friday"></ul>
        <ul class="schedule-list" id="program-saturday"></ul>
        <ul class="schedule-list" id="program-sunday"></ul>
      </div>
    </div>
  </div>
</div>';
}


?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<title>Nexo Player</title>
<meta name="theme-color" content="<?php echo $primaryColor; ?>">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/8.0.1/normalize.min.css">
<link rel="stylesheet" href="https://radios.zonaradio.in/assets/nexo-reset.css">
<link rel="stylesheet" href="https://radios.zonaradio.in/assets/<?php echo $cssFile; ?>">
<script src="https://cdnjs.cloudflare.com/ajax/libs/color-thief/2.3.0/color-thief.umd.js" defer></script>
<script src="https://radios.zonaradio.in/assets/player.js" defer></script>
<script>
  window.player = {
    timeRefresh: 10000,
    programRefresh: 60000,
    base_url: 'https://<?php echo $panel; ?>/panelradiotv/server/public/',
    id_user: '<?php echo $radioId; ?>',
    service: '<?php echo $coverServer; ?>',
    marqueeGap: "1rem",
    marqueeSpeed: 12,
    stream_url: '<?php echo $streamServer; ?>',
    stream_port: '<?php echo $port; ?>',
    fullUrl: 'https://radios.zonaradio.in/'
  }
</script>
<style>
  :root {
    --player-primary: <?php echo $primaryColor; ?>;
    --player-color-opacity: 0.2;
  }
</style>
<?php if ($theme === 'nexo-grid'): ?>
<link href="https://fonts.googleapis.com/css2?family=Funnel+Display:wght@300..800&display=swap" rel="stylesheet">
<style>
  html, body {
    overflow: hidden !important;
    height: 100%;
  }
  .scrollbar, .program-wrapper, .programs-list, .player {
    overflow: hidden !important;
  }
</style>
<?php endif; ?>
</head>
<body>
<div class="nexo-reset">

<?php if ($theme === 'nexo-bar'): ?>
<!-- NEXO BAR THEME -->
<div class="player">
  <div class="container">
    <div class="player-wrapper">
      <div class="player-left">
        <div class="player-picture image">
          <div class="player-picture-wrapper image-wrapper image-change">
            <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" alt="picture">
          </div>
        </div>
        <div class="player-meta">
          <div class="player-content">
            <div class='player-desc player-fix'>
              <span class="badge">Directo</span>
              <div class='player-fix'>
                <div class='player-name station-name'>
                  <span class="skeleton-text">Loading</span>
                </div>
              </div>
            </div>
            <div class="player-fix">
              <div class='player-title player-title-full song-now station-desc'>
                <span class="skeleton-text">Loading Title</span>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="player-right">
        <div class="player-controls">
          <div class="player-volume volume-container is-vertical">
            <button aria-label="Volume" class="player-button player-button-volume volume-toggle">
              <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24">
                <path d="M15.7 16.7a6 6 0 010 0l-1.4-1.4a4 4 0 000-6.6l1.4-1.4a6 6 0 010 9.4Zm3.6 3.6a11 11 0 000-16.6L17.8 5.2a9 9 0 010 13.6l1.5 1.5a11 11 0 000 0ZM2 16q-1 0-1-.9V9Q1 8 2 8H5.9l5.3-4.3a.5.5 0 01.8.4V19.9a.5.5 0 01-.8.4L5.9 16H2Zm4.6-6H3v4H6.6L10 16.8V7.2L6.6 10Z" />
              </svg>
            </button>
            <div class="volume-dropdown">
              <div class="volume-range-wrapper">
                <input class="volume-range-input" max="100" min="0" name="xeplayer" aria-label="Volume" type="range" value="100">
                <div class="volume-range-fill"></div>
                <div class="volume-range-thumb"></div>
              </div>
            </div>
          </div>
          <button aria-label="Play/Pause" class="player-button player-button-play">
            <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24" class="svg-icon">
              <path d="M10.622 8.415A.4.4 0 0010 8.747v6.506a.4.4 0 00.622.332l4.879-3.252a.401.401 0 000-.666l-4.88-3.252ZM12 0a1 1 0 010 24A1 1 0 0112 0Z"></path>
            </svg>
          </button>
          <button aria-label="Programas" class="player-button player-button-schedule" data-outside="program-modal">
            <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24"><path d="M2 6V8H22V6Zm0 5H22v2H2Zm0 5H22v2H2Z"/></svg>
          </button>
          <?php echo getProgramModal(); ?>
        </div>
      </div>
    </div>
  </div>
  <div class="player-equalizer"></div>
  <div class="player-cover image-wrapper image-change">
    <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" alt="cover">
  </div>
</div>

<?php elseif ($theme === 'nexo-banner'): ?>
<!-- NEXO BANNER THEME -->
<link href="https://fonts.googleapis.com/css2?family=Funnel+Display:wght@300..800&display=swap" rel="stylesheet">
<?php echo getProgramModal(); ?>
<div class="player scrollbar">
  <div class="player-wrapper">
    <div class="player-station">
      <div class="player-station-name station-name">
        <span class="skeleton-text">Loading Station</span>
      </div>
    </div>
    <div class="player-picture image">
      <button aria-label="Programas" class="btn player-button player-button-schedule" data-outside="program-modal">
        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24">
          <path d="M3 6V8H21V6Zm0 5H17v2H3Zm0 5H21v2H3Z"/>
        </svg>
      </button>
      <div class="player-picture-wrapper image-wrapper image-change">
        <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" alt="picture">
      </div>
    </div>
    <div class="player-meta">
      <div class="player-content">
        <div class="player-badge">
          <span class="badge">En Directo</span>
        </div>
        <div class="player-fix">
          <div class='player-title song-now station-name'>
            <span class="skeleton-text">Loading Title</span>
          </div>
        </div>
        <div class='player-desc'>
          <div class='player-artist artist-name station-desc'>
            <span class="skeleton-text">Loading</span>
          </div>
        </div>
      </div>
      <div class="social-list"></div>
    </div>
    <div class="player-controls">
      <div class="mini-program"></div>
      <div class="player-volume volume-container is-vertical">
        <button aria-label="Volume" class="player-button player-button-volume volume-toggle">
          <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24">
            <path d="M15.7 16.7a6 6 0 010 0l-1.4-1.4a4 4 0 000-6.6l1.4-1.4a6 6 0 010 9.4Zm3.6 3.6a11 11 0 000-16.6L17.8 5.2a9 9 0 010 13.6l1.5 1.5a11 11 0 000 0ZM2 16q-1 0-1-.9V9Q1 8 2 8H5.9l5.3-4.3a.5.5 0 01.8.4V19.9a.5.5 0 01-.8.4L5.9 16H2Zm4.6-6H3v4H6.6L10 16.8V7.2L6.6 10Z" />
          </svg>
        </button>
        <div class="volume-dropdown">
          <div class="volume-range-wrapper">
            <input class="volume-range-input" max="100" min="0" name="xeplayer" aria-label="Volume" type="range" value="100">
            <div class="volume-range-fill"></div>
            <div class="volume-range-thumb"></div>
          </div>
        </div>
      </div>
      <button aria-label="Play/Pause" class="player-button player-button-play">
        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24" class="svg-icon">
          <path d="M10.622 8.415A.4.4 0 0010 8.747v6.506a.4.4 0 00.622.332l4.879-3.252a.401.401 0 000-.666l-4.88-3.252ZM12 0a1 1 0 010 24A1 1 0 0112 0Z"></path>
        </svg>
      </button>
    </div>
  </div>
  <div class="player-equalizer"></div>
  <div class="player-cover image-wrapper image-change">
    <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" alt="cover">
  </div>
</div>

<?php elseif ($theme === 'nexo-float'): ?>
<!-- NEXO FLOAT THEME -->
<div class="player-float">
  <div class="player-container container">
    <div class="player">
      <div class="player-wrapper">
        <div class="player-left">
          <div class="player-picture image">
            <div class="player-picture-wrapper image-wrapper image-change">
              <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" alt="picture">
            </div>
          </div>
          <div class="player-meta">
            <div class="player-content">
              <div class='player-desc player-fix'>
                <span class="badge">Directo</span>
                <div class='player-fix'>
                  <div class='player-name station-name'>
                    <span class="skeleton-text">Loading</span>
                  </div>
                </div>
              </div>
              <div class="player-fix">
                <div class='player-title player-title-full song-now station-desc'>
                  <span class="skeleton-text">Loading Title</span>
                </div>
              </div>
            </div>
            <div class="mini-program"></div>
          </div>
        </div>
        <div class="player-right">
          <div class="player-controls">
            <div class="player-volume volume-container is-vertical">
              <button aria-label="Volume" class="player-button player-button-volume volume-toggle">
                <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M15.7 16.7a6 6 0 010 0l-1.4-1.4a4 4 0 000-6.6l1.4-1.4a6 6 0 010 9.4Zm3.6 3.6a11 11 0 000-16.6L17.8 5.2a9 9 0 010 13.6l1.5 1.5a11 11 0 000 0ZM2 16q-1 0-1-.9V9Q1 8 2 8H5.9l5.3-4.3a.5.5 0 01.8.4V19.9a.5.5 0 01-.8.4L5.9 16H2Zm4.6-6H3v4H6.6L10 16.8V7.2L6.6 10Z" />
                </svg>
              </button>
              <div class="volume-dropdown">
                <div class="volume-range-wrapper">
                  <input class="volume-range-input" max="100" min="0" name="xeplayer" aria-label="Volume" type="range" value="100">
                  <div class="volume-range-fill"></div>
                  <div class="volume-range-thumb"></div>
                </div>
              </div>
            </div>
            <button aria-label="Play/Pause" class="player-button player-button-play">
              <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24" class="svg-icon">
                <path d="M10.622 8.415A.4.4 0 0010 8.747v6.506a.4.4 0 00.622.332l4.879-3.252a.401.401 0 000-.666l-4.88-3.252ZM12 0a1 1 0 010 24A1 1 0 0112 0Z"></path>
              </svg>
            </button>
            <button aria-label="Programas" class="player-button player-button-schedule" data-outside="program-modal">
              <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24"><path d="M2 6V8H22V6Zm0 5H22v2H2Zm0 5H22v2H2Z"/></svg>
            </button>
            <?php echo getProgramModal(); ?>
          </div>
        </div>
      </div>
      <div class="player-equalizer"></div>
      <div class="player-cover image-wrapper image-change">
        <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" alt="cover">
      </div>
    </div>
  </div>
</div>

<?php else: // nexo-grid ?>
<!-- NEXO GRID THEME -->
<link href="https://fonts.googleapis.com/css2?family=Funnel+Display:wght@300..800&display=swap" rel="stylesheet">
<?php echo getProgramModal(); ?>
<div class="player scrollbar">
  <div class="player-wrapper">
    <div class="player-picture image">
      <div class="player-picture-wrapper image-wrapper image-change">
        <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" alt="picture">
      </div>
      <div class="player-controls">
        <div class="player-volume volume-container is-vertical">
          <button aria-label="Volume" class="player-button player-button-volume volume-toggle">
            <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24">
              <path d="M15.7 16.7a6 6 0 010 0l-1.4-1.4a4 4 0 000-6.6l1.4-1.4a6 6 0 010 9.4Zm3.6 3.6a11 11 0 000-16.6L17.8 5.2a9 9 0 010 13.6l1.5 1.5a11 11 0 000 0ZM2 16q-1 0-1-.9V9Q1 8 2 8H5.9l5.3-4.3a.5.5 0 01.8.4V19.9a.5.5 0 01-.8.4L5.9 16H2Zm4.6-6H3v4H6.6L10 16.8V7.2L6.6 10Z" />
            </svg>
          </button>
          <div class="volume-dropdown">
            <div class="volume-range-wrapper">
              <input class="volume-range-input" max="100" min="0" name="xeplayer" aria-label="Volume" type="range" value="100">
              <div class="volume-range-fill"></div>
              <div class="volume-range-thumb"></div>
            </div>
          </div>
        </div>
        <button aria-label="Play/Pause" class="player-button player-button-play">
          <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24" class="svg-icon">
            <path d="M10.622 8.415A.4.4 0 0010 8.747v6.506a.4.4 0 00.622.332l4.879-3.252a.401.401 0 000-.666l-4.88-3.252ZM12 0a1 1 0 010 24A1 1 0 0112 0Z"></path>
          </svg>
        </button>
      </div>
    </div>
    <div class="player-meta">
      <div class="player-station">
        <div class="player-station-name station-name">
          <span class="skeleton-text">Loading Station</span>
        </div>
      </div>
      <div class="player-content">
        <div class="player-badge">
          <span class="badge">Directo</span>
        </div>
        <div class="player-fix">
          <div class='player-title song-now station-name'>
            <span class="skeleton-text">Loading Title</span>
          </div>
        </div>
        <div class='player-desc'>
          <div class='player-artist artist-name station-desc'>
            <span class="skeleton-text">Loading</span>
          </div>
        </div>
      </div>
    </div>
    <div class="player-redes">
      <p class="social-title">NUESTRAS REDES</p>
      <div class="social-list"></div>
    </div>
  </div>
  <div class="player-equalizer"></div>
  <div class="player-cover image-wrapper image-change">
    <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" alt="cover">
  </div>
</div>
<?php endif; ?>

</div>
</body>
</html>